% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vector_to_overlay.R
\name{vector_to_overlay}
\alias{vector_to_overlay}
\title{Turn spatial vector data into an image overlay}
\usage{
vector_to_overlay(
  vector_data,
  reference_raster,
  output_file = NULL,
  target_crs = 4326,
  transparent = "#ffffff",
  ...
)
}
\arguments{
\item{vector_data}{The spatial vector data set to be transformed into an
overlay image. Users may provide either an \code{sf} object or a length 1
character vector containing a path to a file readable by \link[sf:st_read]{sf::read_sf}.}

\item{reference_raster}{The raster file to produce an overlay for. The output
overlay will have the same extent and resolution as the input raster. Users
may provide either a Raster* object or a length 1 character
vector containing a path to a file readable by \link[raster:raster]{raster::raster}.}

\item{output_file}{The path to save the image overlay to. If \code{NULL}, saves to
a tempfile.}

\item{target_crs}{The CRS (as an EPSG integer code) to transform vector data
into. If using raster images from \link{get_tiles}, the default of 4326 is
typically appropriate.}

\item{transparent}{The hex code for a color to be made transparent in the
final image. Set to \code{FALSE} to not set any colors to transparent.}

\item{...}{Arguments passed to \code{...} in either \link[ggplot2:geom_point]{ggplot2::geom_point} (for
point vector data), \link[ggplot2:geom_path]{ggplot2::geom_line} (for line data),
or \link[ggplot2:geom_polygon]{ggplot2::geom_polygon} (for all other data types).}
}
\value{
\code{output_file}, invisibly.
}
\description{
This function allows users to quickly transform any vector data into an
image overlay, which may then be imported as a texture into Unity.
}
\examples{
\dontrun{

# Generate points to download raster tiles for
set.seed(123)
simulated_data <- data.frame(
  id = seq(1, 100, 1),
  lat = runif(100, 44.1114, 44.1123),
  lng = runif(100, -73.92273, -73.92147)
)

# Create an sf object from our original simulated data

simulated_data_sf <- sf::st_as_sf(simulated_data, coords = c("lng", "lat"))
sf::st_crs(simulated_data_sf) <- sf::st_crs(4326)

# Download data!

downloaded_tiles <- get_tiles(simulated_data_sf, tempfile())

merged_file <- merge_rasters(
  downloaded_tiles[[1]],
  tempfile(fileext = ".tif")
)


# Create an overlay image
vector_to_overlay(simulated_data_sf, merged_file[[1]], na.rm = TRUE)
}

}
\seealso{
Other data manipulation functions: 
\code{\link{combine_overlays}()},
\code{\link{georeference_overlay}()},
\code{\link{merge_rasters}()},
\code{\link{raster_to_raw_tiles}()}

Other overlay creation functions: 
\code{\link{combine_overlays}()},
\code{\link{georeference_overlay}()}

Other visualization functions: 
\code{\link{combine_overlays}()},
\code{\link{geom_spatial_rgb}()},
\code{\link{raster_to_raw_tiles}()}
}
\concept{data manipulation functions}
\concept{overlay creation functions}
\concept{visualization functions}
