% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control_incidence_rate.R
\name{control_incidence_rate}
\alias{control_incidence_rate}
\title{Control function for incidence rate}
\usage{
control_incidence_rate(
  conf_level = 0.95,
  conf_type = c("normal", "normal_log", "exact", "byar"),
  time_unit_input = c("year", "day", "week", "month"),
  time_unit_output = 1
)
}
\arguments{
\item{conf_level}{(\code{proportion})\cr confidence level of the interval.}

\item{conf_type}{(\code{string})\cr \code{normal} (default), \code{normal_log}, \code{exact}, or \code{byar}
for confidence interval type.}

\item{time_unit_input}{(\code{string})\cr \code{day}, \code{month}, or \code{year} (default)
indicating time unit for data input.}

\item{time_unit_output}{(\code{numeric})\cr time unit for desired output (in person-years).}
}
\value{
A list of components with the same names as the arguments.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This is an auxiliary function for controlling arguments for the incidence rate, used
internally to specify details in \code{s_incidence_rate()}.
}
\examples{
control_incidence_rate(0.9, "exact", "month", 100)

}
\seealso{
\link{incidence_rate}
}
