% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariance_plot.R
\name{h_vectorization}
\alias{h_vectorization}
\title{Vectorization helper for Covariance Plot}
\usage{
h_vectorization(vcov_matrix, time_prefix = NULL)
}
\arguments{
\item{vcov_matrix}{(\code{matrix})\cr symmetric covariance matrix with identical
row and column names.}

\item{time_prefix}{(\code{string})\cr string in the names of \code{vcov_matrix} that
precedes the time point value.}
}
\value{
A \code{data.frame} with the upper-diagonal elements of \code{vcov_matrix}.
In the context of repeated measures, this matrix contains the association between pairs
of measurements taken at different time points. It contains the following columns:
\itemize{
\item \code{Vect}: the upper-diagonal elements of \code{vcov_matrix}.
\item \code{time_diff}: the difference between column and row times.
\item \code{lag}: the lag, defined as the difference between column and row ranks.
\item \code{rank_row}: the row rank.
\item \code{rank_col}: the column rank.
}
}
\description{
This function vectorizes the upper-diagonal elements of a symmetric matrix
(e.g. the covariance matrix) and obtains the lag and time distance between
pairs of observations if the time values are part of the names or are part of
the matrix column and row names.
}
\keyword{internal}
