% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pars-terms.R
\name{pars_terms}
\alias{pars_terms}
\title{Term Parameters}
\usage{
pars_terms(x, scalar = NULL, ...)
}
\arguments{
\item{x}{A term vector.}

\item{scalar}{A flag specifying whether to by default return all parameters (NULL), or only scalar parameters (TRUE) or only non-scalar parameters (FALSE).}

\item{...}{Unused.}
}
\value{
A character vector of the term parameter names.
}
\description{
Gets the name of each parameter for each term.
}
\details{
The scalar argument has been \ifelse{html}{\figure{lifecycle-soft-deprecated.svg}{options: alt='Soft-deprecated lifecycle'}}{\strong{Soft-deprecated}}.
}
\examples{
term <- term(
  "alpha[1]", "alpha[2]", "beta[1,1]", "beta[2,1]",
  "beta[1,2]", "beta[2,2]", "sigma", NA
)
pars_terms(term)
}
\seealso{
Other parameters: 
\code{\link{pars.term}()}
}
\concept{parameters}
