% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleK.R
\name{sampleK_alpha}
\alias{sampleK_alpha}
\title{Sample K conditional on \eqn{\alpha} where \eqn{e0 = \alpha/K}.}
\usage{
sampleK_alpha(Kp_j, Kmax, Nk_j, alpha, log_pK)
}
\arguments{
\item{Kp_j}{A number; indicating the current value of \eqn{K_+}.}

\item{Kmax}{A number; indicating the maximum value of \eqn{K} for which the conditional posterior is evaluated.}

\item{Nk_j}{A numeric vector; indicating the group sizes in the partition, i.e.,
the current number of observations in the filled components.}

\item{alpha}{A number; indicating the value of the parameter \eqn{\alpha}.}

\item{log_pK}{A function; evaluating the log prior of \eqn{K}.}
}
\value{
A number indicating the new value of \eqn{K}.
}
\description{
This sampling step only relies on the current
partition and is independent of the current component-specific
parameters, see Frühwirth-Schnatter et al (2021).
}
