% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selafin.R
\name{read_slf_header}
\alias{read_slf_header}
\title{Read slf header}
\usage{
read_slf_header(fname)
}
\arguments{
\item{fname}{\code{character}, name of a SELAFIN file.}
}
\value{
A \code{list} with the following elements:
\describe{
  \item{title}{Title of the file}
  \item{precision}{Precision of numbers (bytes)}
  \item{nbv1}{Number of variables}
  \item{varnames}{Names of variables}
  \item{varunits}{Units of variables}
  \item{date}{Starting date-time (\code{\link{POSIXct}} object)}
  \item{ntimes}{Number of timesteps}
  \item{nelem}{Number of mesh elements (triangles)}
  \item{npoin}{Number of mesh points}
  \item{ndp}{Number of points per element (3 in case of triangles)}
  \item{ikle}{A \code{nelem x ndp} integer matrix of point indices (referring to \code{x} and \code{y}) defining the mesh elements}
  \item{ipobo}{An integer vector of length \code{npoin} defining the mesh boundaries (inner boundaries are zero, outer boundaries numbered)}
  \item{x}{A vector of length \code{npoin} giving the x coordinates of the mesh points}
  \item{y}{A vector of length \code{npoin} giving the y coordinates of the mesh points}
  \item{seek_head}{Position in the SELAFIN file where the header ends (required by function \code{\link{read_slf_variable}})}
}
}
\description{
Reads the header of a SELAFIN file (*.slf).
}
