% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errorhandler.R
\docType{class}
\name{ErrorHandler}
\alias{ErrorHandler}
\alias{is.ErrorHandler}
\title{Handling errors}
\format{An \code{\link{R6Class}} object.}
\usage{
ErrorHandler(callback)

is.ErrorHandler(x)
}
\arguments{
\item{callback}{A function that takes \code{(bot, error)} as arguments.}

\item{x}{Object to be tested.}
}
\description{
\code{\link{Handler}} class to handle errors in the \code{\link{Dispatcher}}.
}
\examples{
\dontrun{
updater <- Updater(token = "TOKEN")

# Create error callback
error_callback <- function(bot, error){
  warning(simpleWarning(conditionMessage(error), call = "Updates polling"))
}

# Register it to the updater's dispatcher
updater$dispatcher$add_handler(ErrorHandler(error_callback))
# or
updater <- updater + ErrorHandler(error_callback)
}
}
