% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inlinequeryresult.R
\name{InlineQueryResult}
\alias{InlineQueryResult}
\title{InlineQueryResult}
\usage{
InlineQueryResult(type, id, ...)
}
\arguments{
\item{type}{Type of the result. See the
\href{https://core.telegram.org/bots/api#inlinequeryresult}{documentation}
for a list of supported types}

\item{id}{Unique identifier for this result, 1-64 Bytes}

\item{...}{Additional parameters for the selected type. See the
\href{https://core.telegram.org/bots/api#inlinequeryresult}{documentation}
for the description of the parameters depending on the \code{InlineQueryResult} type}
}
\description{
Baseclass for the InlineQueryResult* classes.
}
\examples{
\dontrun{
document_url <- "https://github.com/ebeneditos/telegram.bot/raw/gh-pages/docs/telegram.bot.pdf"

result <- InlineQueryResult(
            type = "document",
            id = 1,
            title = "Documentation",
            document_url = document_url,
            mime_type = "application/pdf")
}
}
