#' Plate Boundaries on the Earth
#'
#' Global set of present plate boundaries on the Earth based on PB2002 model by
#' Bird (2003). Contains the plate boundary displacement types such as inward,
#' outward, or tangentially displacement.
#'
#' @docType data
#'
#' @usage data('plates')
#'
#' @format An object of class `sf`
#'
#' @references  Bird, P. (2003), An updated digital model of plate boundaries,
#' *Geochem. Geophys. Geosyst.*, **4**, 1027, doi: 10.1029/2001GC000252, 3.
#'
#' @keywords datasets
#'
#' @examples
#' data("plates")
#' head("plates")
"plates"
