% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module_teal.R
\name{module_teal}
\alias{module_teal}
\alias{ui_teal}
\alias{srv_teal}
\title{\code{teal} main module}
\usage{
ui_teal(id, modules)

srv_teal(id, data, modules, filter = teal_slices())
}
\arguments{
\item{id}{(\code{character(1)}) \code{shiny} module instance id.}

\item{modules}{(\code{teal_modules})
\code{teal_modules} object. These are the specific output modules which
will be displayed in the \code{teal} application. See \code{\link[=modules]{modules()}} and \code{\link[=module]{module()}} for
more details.}

\item{data}{(\code{teal_data}, \code{teal_data_module}, or \code{reactive} returning \code{teal_data})
The data which application will depend on.}

\item{filter}{(\code{teal_slices}) Optionally,
specifies the initial filter using \code{\link[=teal_slices]{teal_slices()}}.}
}
\value{
\code{NULL} invisibly
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Module to create a \code{teal} app as a Shiny Module.
}
\details{
This module can be used instead of \code{\link[=init]{init()}} in custom Shiny applications. Unlike \code{\link[=init]{init()}}, it doesn't
automatically include \code{\link{module_session_info}}.

Module is responsible for creating the main \code{shiny} app layout and initializing all the necessary
components. This module establishes reactive connection between the input \code{data} and every other
component in the app. Reactive change of the \code{data} passed as an argument, reloads the app and
possibly keeps all input settings the same so the user can continue where one left off.
\subsection{data flow in \code{teal} application}{

This module supports multiple data inputs but eventually, they are all converted to \code{reactive}
returning \code{teal_data} in this module. On this \verb{reactive teal_data} object several actions are
performed:
\itemize{
\item data loading in \code{\link{module_init_data}}
\item data filtering in \code{\link{module_filter_data}}
\item data transformation in \code{\link{module_transform_data}}
}
}

\subsection{Fallback on failure}{

\code{teal} is designed in such way that app will never crash if the error is introduced in any
custom \code{shiny} module provided by app developer (e.g. \code{\link[=teal_data_module]{teal_data_module()}}, \code{\link[=teal_transform_module]{teal_transform_module()}}).
If any module returns a failing object, the app will halt the evaluation and display a warning message.
App user should always have a chance to fix the improper input and continue without restarting the session.
}
}
