% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_t_pp_basic_info.R
\name{tm_t_pp_basic_info}
\alias{tm_t_pp_basic_info}
\title{teal Module: Patient Profile Basic Info}
\usage{
tm_t_pp_basic_info(
  label,
  dataname = "ADSL",
  patient_col = "USUBJID",
  vars = NULL,
  pre_output = NULL,
  post_output = NULL
)
}
\arguments{
\item{label}{(\code{character})\cr menu item label of the module in the teal app.}

\item{dataname}{(\code{character})\cr analysis data used in teal module.}

\item{patient_col}{(\code{character})\cr name of patient ID variable.}

\item{vars}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr  object with all
available choices and preselected option for variables from \code{dataname} to show in the table.}

\item{pre_output}{(\code{shiny.tag}) optional,\cr with text placed before the output to put the output into context.
For example a title.}

\item{post_output}{(\code{shiny.tag}) optional,\cr with text placed after the output to put the output into context.
For example the \code{\link[shiny:helpText]{shiny::helpText()}} elements are useful.}
}
\value{
a \code{teal_module} object.
}
\description{
This module produces a patient profile basic info report using ADaM datasets.
}
\examples{
ADSL <- tmc_ex_adsl

app <- init(
  data = cdisc_data(
    ADSL = ADSL,
    code = "ADSL <- tmc_ex_adsl"
  ),
  modules = modules(
    tm_t_pp_basic_info(
      label = "Basic Info",
      dataname = "ADSL",
      patient_col = "USUBJID",
      vars = choices_selected(
        choices = variable_choices(ADSL),
        selected = c("ARM", "AGE", "SEX", "COUNTRY", "RACE", "EOSSTT")
      )
    )
  )
)
if (interactive()) {
  shinyApp(app$ui, app$server)
}

}
