% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testhat-helpers.R
\name{all.equal.join_keys}
\alias{all.equal.join_keys}
\title{Test if two objects are (nearly) equal}
\usage{
\method{all}{equal.join_keys}(target, current, ...)
}
\arguments{
\item{target}{\R object.}

\item{current}{other \R object, to be compared with \code{target}.}

\item{...}{further arguments for different methods. Not used with \code{join_keys}.}
}
\description{
\code{all.equal(target, current)} is a utility to compare \code{join_keys} objects target
and current testing \verb{near equality}.
}
\details{
If they are different, comparison is still made to some extent, and a report
of the differences is returned.
Do not use \code{all.equal} directly in if expressions—either use \code{isTRUE(all.equal(....))}
or identical if appropriate.

The parents attribute comparison tolerates \code{NULL} and empty lists and will find
no difference.

The list containing all the relationships is treated like a map and ignores
entries with \code{NULL} if they exist.
}
\seealso{
\code{\link[base:all.equal]{base::all.equal()}}
}
\keyword{internal}
