% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-get_code_dependency.R
\name{get_code_dependency}
\alias{get_code_dependency}
\title{Get code dependency of an object}
\usage{
get_code_dependency(code, names, check_code_names = TRUE)
}
\arguments{
\item{code}{\code{character} with the code.}

\item{names}{\code{character} vector of object names.}

\item{check_code_names}{\code{logical(1)} flag specifying if a warning for non-existing names should be displayed.}
}
\value{
Character vector, a subset of \code{code}.
Note that subsetting is actually done on the calls \code{code}, not necessarily on the elements of the vector.
}
\description{
Extract subset of code required to reproduce specific object(s), including code producing side-effects.
}
\details{
Given a character vector with code, this function will extract the part of the code responsible for creating
the variables specified by \code{names}.
This includes the final call that creates the variable(s) in question as well as all \emph{parent calls},
\emph{i.e.} calls that create variables used in the final call and their parents, etc.
Also included are calls that create side-effects like establishing connections.

It is assumed that object dependency is established by using three assignment operators: \verb{<-}, \code{=}, and \verb{->} .
Other assignment methods (\code{assign}, \verb{<<-}) or non-standard-evaluation methods are not supported.

Side-effects are not detected automatically and must be marked in the code.
Add \verb{# @linksto object} at the end of a line where a side-effect occurs to specify that this line is required
to reproduce a variable called \code{object}.
}
\keyword{internal}
