% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpd-finalizers.R
\name{vpd-finalizers}
\alias{vpd-finalizers}
\alias{get_pairs_max}
\alias{get_pers_max_frac}
\alias{get_pers_min_mult}
\title{Finalizers for persistent homology vectorizations}
\usage{
get_pairs_max(object, x, hom_degrees = NULL, ...)

get_pers_max_frac(
  object,
  x,
  hom_degree = NULL,
  log_vals = TRUE,
  frac = 1/100,
  ...
)

get_pers_min_mult(
  object,
  x,
  hom_degree = NULL,
  log_vals = TRUE,
  mult = 100,
  ...
)
}
\arguments{
\item{object}{A \code{param} object or a list of \code{param} objects.}

\item{x}{Persistence data in a recognizable format.}

\item{...}{Other arguments to pass to the underlying parameter finalizer
functions.}

\item{hom_degree, hom_degrees}{Integer (vector) of homological degree(s).}

\item{log_vals}{A logical: should the ranges be set on the log10 scale?}

\item{frac}{A double for the fraction of the data to be used for the upper
bound. For \code{get_n_frac_range()} and \code{get_batch_sizes()}, a vector of two
fractional values are required.}

\item{mult}{A double for the multiple of the data to be used for the lower
bound.}
}
\value{
An updated \code{param} object or a list of updated \code{param} objects depending
on what is provided in \code{object}.
}
\description{
These functions take a persistent homology vectorization
parameter object and modify the \code{\link[dials:unknown]{dials::unknown()}} parts of \code{ranges} based
on a data set and heuristics used in inaugural studies.
}
\details{
\code{get_pairs_max()} sets the upper bound to the maximum number of persistent
pairs.

\code{get_pers_max_frac()} sets both bounds to fractions of the maximum finite
persistence (lifespan). A single number is used as the lower bound fraction
and takes the upper bound fraction to be 1.

\code{get_pers_min_mult()} sets both bounds to multiples of the minimum positive
persistence (lifespan). A single number is used as the upper bound multiple
and takes the lower bound multiple to be 1.
}
