% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitcnst.R
\name{fitcnst}
\alias{fitcnst}
\title{Constant Model Fit}
\usage{
fitcnst(conc, resp, nofit = FALSE, errfun = "dt4", ...)
}
\arguments{
\item{conc}{Vector of concentration values NOT in log units.}

\item{resp}{Vector of corresponding responses.}

\item{nofit}{If nofit = TRUE, returns formatted output filled with missing values.}

\item{errfun}{Which error distribution to assume for each point, defaults to
"dt4". "dt4" is the original 4 degrees of freedom t-distribution. Another
supported distribution is "dnorm", the normal distribution.}

\item{...}{Space for parameters so fitcnst can be called similar to other fitting functions (currently unused)}
}
\value{
List of five elements: success, aic (Akaike Information Criteria),
  rme (root mean square error), er (error parameter), pars (parameter names).
}
\description{
Function that fits a constant line \eqn{f(x) = 0} and returns generic
model outputs.
}
\details{
success = 1 for a successful fit, 0 if optimization failed, and NA if
nofit = TRUE. aic, rme, and er are set to NA in case of nofit or failure. pars
always equals "er".
}
\examples{
fitcnst(c(.1,1,10,100), c(1,2,0,-1))
fitcnst(c(.1,1,10,100), c(1,2,0,-1), nofit = TRUE)
}
