% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tci_algorithms.R
\name{tci_pd}
\alias{tci_pd}
\title{Function to extend TCI grid to a set of PD targets}
\usage{
tci_pd(pdresp, tms, pkmod, pdmod, pars_pk, pars_pd, pdinv, ecmpt = NULL, ...)
}
\arguments{
\item{pdresp}{PD targets to be passed on to the TCI algorithm.}

\item{tms}{Times corresponding to each PD target}

\item{pkmod}{PK model function}

\item{pdmod}{PD model function}

\item{pars_pk}{PK model parameters}

\item{pars_pd}{PD model parameters}

\item{pdinv}{PD inverse function}

\item{ecmpt}{Number corresponding to effect-site compartment. Defaults
to the last compartment.}

\item{...}{Arguments to be passed on to 'tci'. These can include alternate
TCI algorithms if desired.}
}
\value{
Matrix of infusions with class "tciinf" calculated to reach PD targets.
}
\description{
Function to extend TCI grid to a set of PD targets
}
\examples{
tci_pd(pdresp = c(80,70,70), tms = c(2,4,6), pkmod = pkmod2cpt, pdmod = emax,
pars_pk = c(CL = 15, V1 = 10, Q2 = 10, V2 = 20),
pars_pd = c(c50 = 1.5, gamma = 1.47, e0 = 100, emx = 100),
pdinv = inv_emax)
}
