#'tcgsaseq: a package to perform Time-course Gene Set Analysis and General Gene-Wise Analysis of RNA-seq data
#'
#'Analysis of RNA-seq data with variance component score
#'test accounting for data heteroscedasticity through precision weights.
#'
#'\tabular{ll}{
#'Package: \tab tcgsaseq\cr
#'Type: \tab Package\cr
#'Version: \tab 1.6.3\cr
#'Date: \tab 2017-11-09\cr
#'License:\tab \href{http://www.gnu.org/licenses/gpl-2.0.txt}{GPL-2}\cr
#'}
#'The two main functions of the \code{tcgsaseq} package are \code{\link{varseq}} and \code{\link{tcgsa_seq}}.
#'
#'
#'@author Boris P. Hejblum, Denis Agniel
#'--- Maintainer: Boris P. Hejblum
#'
#'@references Agniel D & Hejblum BP (2017). Variance component score test for
#'time-course gene set analysis of longitudinal RNA-seq data, \emph{Biostatistics},
#'18(4):589-604. \href{https://doi.org/10.1093/biostatistics/kxx005}{10.1093/biostatistics/kxx005}.
#'\href{https://arxiv.org/abs/1605.02351}{arXiv:1605.02351}.
#'
#'
#'@docType package
#'@name tcgsaseq
#'@importFrom GSA GSA.read.gmt
#'
NULL
