% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eol_dataobjects.R
\name{eol_dataobjects}
\alias{eol_dataobjects}
\title{Given the identifier for a data object, return all metadata about the object}
\usage{
eol_dataobjects(id, taxonomy = TRUE, language = NULL, usekey = TRUE,
  key = NULL, ...)
}
\arguments{
\item{id}{(character) The EOL data object identifier}

\item{taxonomy}{(logical) Whether to return any taxonomy details from 
different taxon hierarchy providers, in an array named 
\code{taxonconcepts}}

\item{language}{(character) provides the results in the specified language. 
one of ms, de, en, es, fr, gl, it, nl, nb, oc, pt-BR, sv, tl, mk, sr, uk, ar, 
zh-Hans, zh-Hant, ko}

\item{usekey}{(logical) use your API key or not (\code{TRUE} or \code{FALSE})}

\item{key}{(character) Your EOL API key; ; see \code{\link{taxize-authentication}} 
for help on authentication}

\item{...}{Curl options passed on to \code{\link[crul]{HttpClient}}}
}
\value{
A list, optionally with a data.frame if \code{taxonomy=TRUE}
}
\description{
Given the identifier for a data object, return all metadata about the object
}
\details{
It's possible to return JSON or XML with the EOL API. However,
		this function only returns JSON for now.
}
\examples{
\dontrun{
eol_dataobjects(id = 7561533)

# curl options
eol_dataobjects(id = 7561533, verbose = TRUE)
}
}
