% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eubon.R
\name{eubon}
\alias{eubon}
\title{EU BON taxonomy}
\usage{
eubon(query, providers = "pesi", searchMode = "scientificNameExact",
  addSynonymy = FALSE, timeout = 0, ...)
}
\arguments{
\item{query}{(character) The scientific name to search for. For example: "Bellis perennis",
"Prionus" or "Bolinus brandaris". This is an exact search so wildcard characters
are not supported}

\item{providers}{(character) A list of provider id strings concatenated by comma characters.
The default : "pesi,bgbm-cdm-server[col]" will be used if this parameter is not
set. A list of all available provider ids can be obtained from the '/capabilities'
service end point. Providers can be nested, that is a parent provider can have sub
providers. If the id of the parent provider is supplied all subproviders will be
queried. The query can also be restriced to one or more subproviders by using the
following syntax: parent-id[sub-id-1,sub-id2,...]}

\item{searchMode}{(character) Specifies the searchMode. Possible search modes are:
scientificNameExact, scientificNameLike (begins with), vernacularNameExact, vernacularNameLike
(contains), findByIdentifier. If the a provider does not support the chosen searchMode it
will be skipped and the status message in the tnrClientStatus will be set to 'unsupported
search mode' in this case.}

\item{addSynonymy}{(logical) Indicates whether the synonymy of the accepted taxon should be
included into the response. Turning this option on may cause an increased response time.
Default: \code{FALSE}}

\item{timeout}{(numeric) The maximum of milliseconds to wait for responses from any of the
providers. If the timeout is exceeded the service will jut return the resonses that have
been received so far. The default timeout is 0 ms (wait for ever)}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\description{
EU BON taxonomy
}
\details{
Note that paging is not yet implemented, so you only get the first chunk
of up to 50 results for methods that require paging. We will implement paging
here when it is available in the EU BON API.
}
\examples{
\dontrun{
eubon("Prionus")
eubon("Salmo", 'worms')
eubon("Salmo", c('pesi', 'worms'))
eubon("Salmo", 'worms', 'scientificNameLike')
}
}
\references{
\url{http://cybertaxonomy.eu/eubon-utis/doc.html}
}

