% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ncbi_get_taxon_summary.R
\name{ncbi_get_taxon_summary}
\alias{ncbi_get_taxon_summary}
\title{NCBI taxon information from uids}
\usage{
ncbi_get_taxon_summary(id)
}
\arguments{
\item{id}{(character) NCBI taxonomy uids to retrieve information for.}
}
\value{
A \code{data.frame} with the following rows:
  \describe{
    \item{uid}{The uid queried for}
    \item{name}{The name of the taxon; a binomial name if the taxon is of rank species}
    \item{rank}{The taxonomic rank (e.g. 'Genus')}
  }
}
\description{
Downloads summary taxon information from the NCBI taxonomy databases for a set of taxonomy uids
using eutils esummary.
}
\examples{
\dontrun{
ncbi_get_taxon_summary(c(1430660, 4751))
}
}
\author{
Zachary Foster \email{zacharyfoster1989@Sgmail.com}
}

