% Generated by roxygen2 (4.0.1): do not edit by hand
\name{children}
\alias{children}
\alias{children.colid}
\alias{children.default}
\alias{children.ids}
\alias{children.tsn}
\title{Retrieve immediate children taxa for a given taxon name or ID.}
\usage{
children(...)

\method{children}{default}(x, db = NULL, ...)

\method{children}{tsn}(x, db = NULL, ...)

\method{children}{colid}(x, db = NULL, ...)

\method{children}{ids}(x, db = NULL, ...)
}
\arguments{
\item{x}{character; taxons to query.}

\item{db}{character; database to query. One or more of \code{itis}, or \code{col}.}

\item{...}{Further args passed on to \code{col_children}, or
\code{gethierarchydownfromtsn}. See those functions for what parameters can be passed on.}
}
\value{
A named list of data.frames with the children names of every supplied taxa.
You get an NA if there was no match in the database.
}
\description{
This function is different from \code{downstream()} in that it only collects immediate
taxonomic children, while \code{downstream()} collects taxonomic names down to a specified
taxonomic rank, e.g., getting all species in a family.
}
\examples{
\donttest{
# Plug in taxon names
children("Salmo", db = 'col')
children("Salmo", db = 'itis')

# Plug in IDs
(id <- get_colid("Apis"))
children(id)

## Equivalently, plug in the call to get the id via e.g., get_colid into children
identical(children(id), children(get_colid("Apis")))

(id <- get_colid("Apis"))
children(id)
children(get_colid("Apis"))

# Many taxa
(sp <- names_list("genus", 3))
children(sp, db = 'col')
children(sp, db = 'itis')

# Two data sources
(ids <- get_ids("Apis", db = c('col','itis')))
children(ids)
## same result
children(get_ids("Apis", db = c('col','itis')))
}
}

