% Generated by roxygen2 (4.0.0): do not edit by hand
\name{gettsnfromlsid}
\alias{gettsnfromlsid}
\title{Gets the TSN corresponding to the LSID, or an empty result if there is no match.}
\usage{
gettsnfromlsid(lsid = NA, curlopts = list(), curl = getCurlHandle(),
  verbose = TRUE)
}
\arguments{
\item{lsid}{lsid for a taxonomic group (numeric)}

\item{curlopts}{optional additional curl options (debugging tools mostly)}

\item{curl}{If using in a loop, call getCurlHandle() first and pass
the returned value in here (avoids unnecessary footprint)}

\item{verbose}{(logical) Print messages or not. Default to TRUE.}
}
\description{
Gets the TSN corresponding to the LSID, or an empty result if there is no match.
}
\examples{
\dontrun{
gettsnfromlsid(lsid = "urn:lsid:itis.gov:itis_tsn:28726")
gettsnfromlsid(lsid = "urn:lsid:itis.gov:itis_tsn:0")
}
}
\keyword{internal}

