% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/td_connect.R
\name{td_connect}
\alias{td_connect}
\title{Connect to the taxadb database}
\usage{
td_connect(dbdir = taxadb_dir(), driver = Sys.getenv("TAXADB_DRIVER"))
}
\arguments{
\item{dbdir}{Path to the database.}

\item{driver}{Default driver, one of "duckdb", "MonetDBLite", "RSQLite".
\code{taxadb} will select the first one of those it finds available if a
driver is not set. This fallback can be overwritten either by explicit
argument or by setting the environmental variable \code{TAXADB_DRIVER}.}
}
\value{
Returns a \code{src_dbi} connection to the default duckdb database
}
\description{
Connect to the taxadb database
}
\details{
This function provides a default database connection for
\code{taxadb}. Note that you can use \code{taxadb} with any DBI-compatible database
connection  by passing the connection object directly to \code{taxadb}
functions using the \code{db} argument. \code{td_connect()} exists only to provide
reasonable automatic defaults based on what is available on your system.

\code{duckdb} or \code{MonetDBLite} will give the best performance, and regular users
\code{taxadb} will work with the built-in \code{RSQlite}, and with other database
connections such as Postgres or MariaDB, but queries (filtering joins)
will be much slower on these non-columnar databases.

For performance reasons, this function will also cache and restore the
existing database connection, making repeated calls to \code{td_connect()} much
faster and more failsafe than repeated calls to \link[DBI:dbConnect]{DBI::dbConnect}
}
\examples{
\donttest{
## OPTIONAL: you can first set an alternative home location,
## such as a temporary directory:
Sys.setenv(TAXADB_HOME=tempdir())

## Connect to the database:
db <- td_connect()

}
}
