% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ids.R
\name{get_ids}
\alias{get_ids}
\title{get_ids}
\usage{
get_ids(
  names,
  db = getOption("taxadb_default_provider", "itis"),
  format = c("prefix", "bare", "uri"),
  version = latest_version(),
  taxadb_db = td_connect(),
  ignore_case = TRUE,
  ...
)
}
\arguments{
\item{names}{a list of scientific names (which may
include higher-order ranks in most authorities).}

\item{db}{abbreviation code for the provider.  See details.}

\item{format}{Format for the returned identifier, one of
\itemize{
\item \code{prefix} (e.g. \code{NCBI:9606}, the default), or
\item \code{bare} (e.g. \code{9606}, used in \code{taxize::get_ids()}),
\item \code{uri} (e.g.
\verb{http://ncbi.nlm.nih.gov/taxonomy/9606}).
}}

\item{version}{Which version of the taxadb provider database should we use?
defaults to latest.  see \verb{[avialable_releases()]} for details.}

\item{taxadb_db}{Connection to from \verb{[td_connect()]}.}

\item{ignore_case}{should we ignore case (capitalization) in matching names?
default is \code{TRUE}.}

\item{...}{additional arguments (currently ignored)}
}
\value{
a vector of IDs, of the same length as the input names Any
unmatched names or multiply-matched names will return as \link{NA}s.
To resolve multi-matched names, use \verb{[filter_name()]} instead to return
a table with a separate row for each separate match of the input name.
}
\description{
A drop-in replacement for \verb{[taxize::get_ids()]}
}
\details{
Note that some taxize authorities: \code{nbn}, \code{tropicos}, and \code{eol},
are not recognized by taxadb and will throw an error here. Meanwhile,
taxadb recognizes several authorities not known to \verb{[taxize::get_ids()]}.
Both include \code{itis}, \code{ncbi}, \code{col}, and \code{gbif}.

Like all taxadb functions, this function will run
fastest if a local copy of the provider is installed in advance
using \verb{[td_create()]}.
}
\examples{
\donttest{
get_ids("Homo sapiens")
get_ids(c("Homo sapiens", "Mammalia"), format = "prefix")
get_ids("Homo sapiens", db= "ncbi", format = "uri")
}
}
\seealso{
filter_name

Other get: 
\code{\link{get_names}()}
}
\concept{get}
