% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tau.fit.R
\name{tau.fit}
\alias{tau.fit}
\title{Estimate the Tau Process}
\usage{
tau.fit(data, t = numeric())
}
\arguments{
\item{data}{a data.frame consisting of \code{arm}, \code{surv.time}, \code{event}.}

\item{t}{a sequence of specified times. If the user do not specify the sequence, the default is an equally-spaced sequence from 0 to the last identified time.}
}
\value{
an object of class "tauFit" with components
\tabular{ll}{
\code{N0} \tab number of individuals with arm=0 \cr
\tab \cr
\code{N1} \tab number of individuals with arm=1 \cr
\tab \cr
\code{t} \tab the specified truncation time \cr
\tab \cr
\code{tau} \tab the estimated value of tau measure \cr
\tab \cr
\code{var.r} \tab the estimated variance under random grouping design (complete randomization design)\cr
\tab \cr
\code{var.f} \tab the estimated variance under fixed grouping design (random allocation rule / urn model)\cr
}
}
\description{
Estimate the tau process at specified time points.
The estimated variances at the last time point under complete randomization design and random allocation rule (urn model) are provided.
}
\details{
The estimation and inference procedure are proposed by Yi-Cheng Tai, Weijing Wang and Martin T. Wells.
The value of tau measure serves as a clinically meaningful measure of treatment effect.
It supplements the traditional hazard ratio (HR) under nonproportional hazard scenario.
}
\examples{
tau.fit(data = pbc)

}
