% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_option_set.R
\name{tar_option_set}
\alias{tar_option_set}
\title{Set target options.}
\usage{
tar_option_set(
  tidy_eval = NULL,
  packages = NULL,
  imports = NULL,
  library = NULL,
  envir = NULL,
  format = NULL,
  iteration = NULL,
  error = NULL,
  memory = NULL,
  garbage_collection = NULL,
  deployment = NULL,
  priority = NULL,
  backoff = NULL,
  resources = NULL,
  storage = NULL,
  retrieval = NULL,
  cue = NULL,
  debug = NULL,
  workspaces = NULL
)
}
\arguments{
\item{tidy_eval}{Logical, whether to enable tidy evaluation
when interpreting \code{command} and \code{pattern}. If \code{TRUE}, you can use the
"bang-bang" operator \verb{!!} to programmatically insert
the values of global objects.}

\item{packages}{Character vector of packages to load right before
the target builds. Use \code{tar_option_set()} to set packages
globally for all subsequent targets you define.}

\item{imports}{Character vector of package names to track
global dependencies. For example, if you write
\code{tar_option_set(imports = "yourAnalysisPackage")} early in \verb{_targets.R},
then \code{tar_make()} will automatically rerun or skip targets
in response to changes to the R functions and objects defined in
\code{yourAnalysisPackage}. Does not account for low-level compiled code
such as C/C++ or Fortran. If you supply multiple packages,
e.g. \code{tar_option_set(imports = c("p1", "p2"))}, then the objects in
\code{p1} override the objects in \code{p2} if there are name conflicts.
Similarly, objects in \code{tar_option_get("envir")} override
everything in \code{tar_option_get("imports")}.}

\item{library}{Character vector of library paths to try
when loading \code{packages}.}

\item{envir}{Environment containing functions and global objects
used in the R commands to run targets. Defaults to the global environment.
If \code{envir} is the global environment, all the promise objects
are diffused before sending the data to parallel workers
in \code{\link[=tar_make_future]{tar_make_future()}} and \code{\link[=tar_make_clustermq]{tar_make_clustermq()}},
but otherwise the environment is unmodified.
This behavior improves performance by decreasing
the size of data sent to workers.

If \code{envir} is not the global environment, then it should at least inherit
from the global environment or base environment
so \code{targets} can access attached packages.
In the case of a non-global \code{envir}, \code{targets} attempts to remove
potentially high memory objects that come directly from \code{targets}.
That includes \code{tar_target()} objects of class \code{"tar_target"},
as well as objects of class \code{"tar_pipeline"} or \code{"tar_algorithm"}.
This behavior improves performance by decreasing
the size of data sent to workers.

Package environments should not be assigned to \code{envir}.
To include package objects as upstream dependencies in the pipeline,
assign the package to the \code{packages} and \code{imports} arguments
of \code{tar_option_set()}.}

\item{format}{Optional storage format for the target's return value.
With the exception of \code{format = "file"}, each target
gets a file in \verb{_targets/objects}, and each format is a different
way to save and load this file.
Possible formats:
\itemize{
\item \code{"rds"}: Default, uses \code{saveRDS()} and \code{readRDS()}. Should work for
most objects, but slow.
\item \code{"qs"}: Uses \code{qs::qsave()} and \code{qs::qread()}. Should work for
most objects, much faster than \code{"rds"}. Optionally set the
preset for \code{qsave()} through the \code{resources} argument, e.g.
\code{tar_target(..., resources = list(preset = "archive"))}.
Requires the \code{qs} package (not installed by default).
\item \code{"feather"}: Uses \code{arrow::write_feather()} and
\code{arrow::read_feather()} (version 2.0). Much faster than \code{"rds"},
but the value must be a data frame. Optionally set
\code{compression} and \code{compression_level} in \code{arrow::write_feather()}
through the \code{resources} argument, e.g.
\code{tar_target(..., resources = list(compression = ...))}.
Requires the \code{arrow} package (not installed by default).
\item \code{"parquet"}: Uses \code{arrow::write_parquet()} and
\code{arrow::read_parquet()} (version 2.0). Much faster than \code{"rds"},
but the value must be a data frame. Optionally set
\code{compression} and \code{compression_level} in \code{arrow::write_parquet()}
through the \code{resources} argument, e.g.
\code{tar_target(..., resources = list(compression = ...))}.
Requires the \code{arrow} package (not installed by default).
\item \code{"fst"}: Uses \code{fst::write_fst()} and \code{fst::read_fst()}.
Much faster than \code{"rds"}, but the value must be
a data frame. Optionally set the compression level for
\code{fst::write_fst()} through the \code{resources} argument, e.g.
\code{tar_target(..., resources = list(compress = 100))}.
Requires the \code{fst} package (not installed by default).
\item \code{"fst_dt"}: Same as \code{"fst"}, but the value is a \code{data.table}.
Optionally set the compression level the same way as for \code{"fst"}.
\item \code{"fst_tbl"}: Same as \code{"fst"}, but the value is a \code{tibble}.
Optionally set the compression level the same way as for \code{"fst"}.
\item \code{"keras"}: Uses \code{keras::save_model_hdf5()} and
\code{keras::load_model_hdf5()}. The value must be a Keras model.
Requires the \code{keras} package (not installed by default).
\item \code{"torch"}: Uses \code{torch::torch_save()} and \code{torch::torch_load()}.
The value must be an object from the \code{torch} package
such as a tensor or neural network module.
Requires the \code{torch} package (not installed by default).
\item \code{"file"}: A dynamic file. To use this format,
the target needs to manually identify or save some data
and return a character vector of paths
to the data. (These paths must be existing files
and nonempty directories.)
Then, \code{targets} automatically checks those files and cues
the appropriate build decisions if those files are out of date.
Those paths must point to files or directories,
and they must not contain characters \code{|} or \code{*}.
All the files and directories you return must actually exist,
or else \code{targets} will throw an error. (And if \code{storage} is \code{"worker"},
\code{targets} will first stall out trying to wait for the file
to arrive over a network file system.)
\item \code{"url"}: A dynamic input URL. It works like \code{format = "file"}
except the return value of the target is a URL that already exists
and serves as input data for downstream targets. Optionally
supply a custom \code{curl} handle through the \code{resources} argument, e.g.
\code{tar_target(..., resources = list(handle = curl::new_handle(nobody = TRUE)))}. # nolint
in \code{new_handle()}, \code{nobody = TRUE} is important because it
ensures \code{targets} just downloads the metadata instead of
the entire data file when it checks time stamps and hashes.
The data file at the URL needs to have an ETag or a Last-Modified
time stamp, or else the target will throw an error because
it cannot track the data. Also, use extreme caution when
trying to use \code{format = "url"} to track uploads. You must be absolutely
certain the ETag and Last-Modified time stamp are fully updated
and available by the time the target's command finishes running.
\code{targets} makes no attempt to wait for the web server.
\item \code{"aws_rds"}, \code{"aws_qs"}, \code{"aws_parquet"}, \code{"aws_fst"}, \code{"aws_fst_dt"},
\code{"aws_fst_tbl"}, \code{"aws_keras"}: AWS-powered versions of the
respective formats \code{"rds"}, \code{"qs"}, etc. The only difference
is that the data file is uploaded to the AWS S3 bucket
you supply to \code{resources}. See the cloud computing chapter
of the manual for details.
\item \code{"aws_file"}: arbitrary dynamic files on AWS S3. The target
should return a path to a temporary local file, then
\code{targets} will automatically upload this file to an S3
bucket and track it for you. Unlike \code{format = "file"},
\code{format = "aws_file"} can only handle one single file,
and that file must not be a directory.
\code{\link[=tar_read]{tar_read()}} and downstream targets
download the file to \verb{_targets/scratch/} locally and return the path.
\verb{_targets/scratch/} gets deleted at the end of \code{\link[=tar_make]{tar_make()}}.
Requires the same \code{resources} and other configuration details
as the other AWS-powered formats. See the cloud computing
chapter of the manual for details.
}}

\item{iteration}{Character of length 1, name of the iteration mode
of the target. Choices:
\itemize{
\item \code{"vector"}: branching happens with \code{vctrs::vec_slice()} and
aggregation happens with \code{vctrs::vec_c()}.
\item \code{"list"}, branching happens with \verb{[[]]} and aggregation happens with
\code{list()}.
\item \code{"group"}: \code{dplyr::group_by()}-like functionality to branch over
subsets of a data frame. The target's return value must be a data
frame with a special \code{tar_group} column of consecutive integers
from 1 through the number of groups. Each integer designates a group,
and a branch is created for each collection of rows in a group.
See the \code{\link[=tar_group]{tar_group()}} function to see how you can
create the special \code{tar_group} column with \code{dplyr::group_by()}.
}}

\item{error}{Character of length 1, what to do if the target
runs into an error. If \code{"stop"}, the whole pipeline stops
and throws an error. If \code{"continue"}, the error is recorded,
but the pipeline keeps going. \code{error = "workspace"} is just like
\code{error = "stop"} except \code{targets} saves a special workspace file
to support interactive debugging outside the pipeline.
(Visit \url{https://books.ropensci.org/targets/debugging.html}
to learn how to debug targets using saved workspaces.)}

\item{memory}{Character of length 1, memory strategy.
If \code{"persistent"}, the target stays in memory
until the end of the pipeline (unless \code{storage} is \code{"worker"},
in which case \code{targets} unloads the value from memory
right after storing it in order to avoid sending
copious data over a network).
If \code{"transient"}, the target gets unloaded
after every new target completes.
Either way, the target gets automatically loaded into memory
whenever another target needs the value.
For cloud-based dynamic files such as \code{format = "aws_file"},
this memory policy applies to
temporary local copies of the file in \verb{_targets/scratch/"}:
\code{"persistent"} means they remain until the end of the pipeline,
and \code{"transient"} means they get deleted from the file system
as soon as possible. The former conserves bandwidth,
and the latter conserves local storage.}

\item{garbage_collection}{Logical, whether to run \code{base::gc()}
just before the target runs.}

\item{deployment}{Character of length 1, only relevant to
\code{\link[=tar_make_clustermq]{tar_make_clustermq()}} and \code{\link[=tar_make_future]{tar_make_future()}}. If \code{"worker"},
the target builds on a parallel worker. If \code{"main"},
the target builds on the host machine / process managing the pipeline.}

\item{priority}{Numeric of length 1 between 0 and 1. Controls which
targets get deployed first when multiple competing targets are ready
simultaneously. Targets with priorities closer to 1 get built earlier
(and polled earlier in \code{\link[=tar_make_future]{tar_make_future()}}).
Only applies to \code{\link[=tar_make_future]{tar_make_future()}} and \code{\link[=tar_make_clustermq]{tar_make_clustermq()}}
(not \code{\link[=tar_make]{tar_make()}}). \code{\link[=tar_make_future]{tar_make_future()}} with no extra settings is
a drop-in replacement for \code{\link[=tar_make]{tar_make()}} in this case.}

\item{backoff}{Numeric of length 1, must be greater than or equal to 0.01.
Maximum upper bound of the random polling interval
for the priority queue (seconds).
In high-performance computing (e.g. \code{\link[=tar_make_clustermq]{tar_make_clustermq()}}
and \code{\link[=tar_make_future]{tar_make_future()}}) it can be expensive to repeatedly poll the
priority queue if no targets are ready to process. The number of seconds
between polls is \code{runif(1, 0.01, max(backoff, 0.01 * 1.5 ^ index))},
where \code{index} is the number of consecutive polls so far that found
no targets ready to skip or run.
(If no target is ready, \code{index} goes up by 1. If a target is ready,
\code{index} resets to 0. For more information on exponential,
backoff, visit \url{https://en.wikipedia.org/wiki/Exponential_backoff}).
Raising \code{backoff} is kinder to the CPU etc. but may incur delays
in some instances.}

\item{resources}{A named list of computing resources. Uses:
\itemize{
\item Template file wildcards for \code{future::future()} in \code{\link[=tar_make_future]{tar_make_future()}}.
\item Template file wildcards \code{clustermq::workers()} in \code{\link[=tar_make_clustermq]{tar_make_clustermq()}}.
\item Custom target-level \code{future::plan()}, e.g.
\code{resources = list(plan = future.callr::callr)}.
\item Custom \code{curl} handle if \code{format = "url"},
e.g. \code{resources = list(handle = curl::new_handle(nobody = TRUE))}.
In custom handles, most users should manually set \code{nobody = TRUE}
so \code{targets} does not download the entire file when it
only needs to check the time stamp and ETag.
\item Custom preset for \code{qs::qsave()} if \code{format = "qs"}, e.g.
\code{resources = list(handle = "archive")}.
\item Arguments \code{compression} and \code{compression_level} to
\code{arrow::write_feather()} and \code{arrow:write_parquet()} if \code{format} is
\code{"feather"}, \code{"parquet"}, \code{"aws_feather"}, or \code{"aws_parquet"}.
\item Custom compression level for \code{fst::write_fst()} if
\code{format} is \code{"fst"}, \code{"fst_dt"}, or \code{"fst_tbl"}, e.g.
\code{resources = list(compress = 100)}.
\item AWS bucket and prefix for the \code{"aws_"} formats, e.g.
\code{resources = list(bucket = "your-bucket", prefix = "folder/name")}.
\code{bucket} is required for AWS formats. See the cloud computing chapter
of the manual for details.
}}

\item{storage}{Character of length 1, only relevant to
\code{\link[=tar_make_clustermq]{tar_make_clustermq()}} and \code{\link[=tar_make_future]{tar_make_future()}}.
If \code{"main"}, the target's return value is sent back to the
host machine and saved locally. If \code{"worker"}, the worker
saves the value.}

\item{retrieval}{Character of length 1, only relevant to
\code{\link[=tar_make_clustermq]{tar_make_clustermq()}} and \code{\link[=tar_make_future]{tar_make_future()}}.
If \code{"main"}, the target's dependencies are loaded on the host machine
and sent to the worker before the target builds.
If \code{"worker"}, the worker loads the targets dependencies.}

\item{cue}{An optional object from \code{tar_cue()} to customize the
rules that decide whether the target is up to date.}

\item{debug}{Character vector of names of targets to run in debug mode.
To use effectively, you must set \code{callr_function = NULL} and
restart your R session just before running. You should also
\code{\link[=tar_make]{tar_make()}}, \code{\link[=tar_make_clustermq]{tar_make_clustermq()}}, or \code{\link[=tar_make_future]{tar_make_future()}}.
For any target mentioned in \code{debug}, \code{targets} will force the target to
build locally (with \code{tar_cue(mode = "always")} and \code{deployment = "main"}
in the settings) and pause in an interactive debugger to help you diagnose
problems. This is like inserting a \code{browser()} statement at the
beginning of the target's expression, but without invalidating any
targets.}

\item{workspaces}{Character vector of names of targets to save workspace
files. Workspace files let you re-create a target's runtime environment
in an interactive R session using \code{\link[=tar_workspace]{tar_workspace()}}. \code{\link[=tar_workspace]{tar_workspace()}}
loads a target's random number generator seed and dependency objects
as long as those target objects are still in the data store
(usually \verb{_targets/objects/}).}
}
\value{
\code{NULL} (invisibly).
}
\description{
Set target options, including default arguments to
\code{\link[=tar_target]{tar_target()}} such as packages, storage format,
iteration type, and cue. See default options with \code{\link[=tar_option_get]{tar_option_get()}}.
To use \code{tar_option_set()} effectively, put it in your workflow's
\verb{_targets.R} script before calls to \code{\link[=tar_target]{tar_target()}} or \code{\link[=tar_target_raw]{tar_target_raw()}}.
}
\examples{
tar_option_get("format") # default format before we set anything
tar_target(x, 1)$settings$format
tar_option_set(format = "fst_tbl") # new default format
tar_option_get("format")
tar_target(x, 1)$settings$format
tar_option_reset() # reset the format
tar_target(x, 1)$settings$format
if (identical(Sys.getenv("TAR_LONG_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_script({
  tar_option_set(cue = tar_cue(mode = "always")) # All targets always run.
  list(tar_target(x, 1), tar_target(y, 2))
})
tar_make()
tar_make()
})
}
}
\seealso{
Other configuration: 
\code{\link{tar_config_get}()},
\code{\link{tar_config_set}()},
\code{\link{tar_envvars}()},
\code{\link{tar_option_get}()},
\code{\link{tar_option_reset}()}
}
\concept{configuration}
