% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_helper_raw.R
\name{tar_helper_raw}
\alias{tar_helper_raw}
\title{Write a helper R script (raw version).}
\usage{
tar_helper_raw(path = NULL, code = NULL)
}
\arguments{
\item{path}{Character of length 1, path to write (or overwrite) \code{code}.
If the parent directory does not exist, \code{tar_helper_raw()} creates it.}

\item{code}{Expression object. \code{tar_helper_raw()} deparses and writes
this code to a file at \code{path}, overwriting it if the file already exists.}
}
\value{
\code{NULL} (invisibly)
}
\description{
Write a helper R script for a \code{targets} pipeline.
Could be supporting functions or the \verb{_targets.R} file itself.
}
\details{
\code{tar_helper_raw()} is a specialized version of \code{\link[=tar_script]{tar_script()}}
with flexible paths and tidy evaluation. It is like \code{\link[=tar_helper]{tar_helper()}}
except that \code{code} is an "evaluated" argument rather than a quoted one.
}
\examples{
path <- tempfile()
tar_helper_raw(path, quote(x <- 1))
writeLines(readLines(path))
}
