tar_test("tar_source()", {
  skip_on_cran()
  dir.create("x")
  dir.create("y")
  dir.create(file.path("y", "z"))
  writeLines("f <- function(x) x + 1L", file.path("x", "f.R"))
  writeLines("g <- function(x) x + 1L", file.path("x", "g.r"))
  writeLines("h <- function(x) x + 1L", file.path("y", "h.R"))
  writeLines("i <- function(x) x + 1L", file.path("y", "z", "i.R"))
  writeLines("j <- function(x) x + 1L", "j.r")
  writeLines("import numpy as np", file.path("x", "k.py"))
  writeLines("import numpy as np", "l.py")
  expect_silent(tar_source("y"))
  expect_warning(tar_source("l.py"), class = "tar_condition_validate")
  expect_warning(tar_source("nope.R"), class = "tar_condition_validate")
  tar_script({
    suppressWarnings(tar_source(c("x", "y", "j.r", "l.py")))
    tar_target(x, f(g(h(i(j(0L))))))
  })
  tar_make(callr_function = NULL)
  expect_equal(tar_read(x), 5L)
})
