% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ate.R
\name{ate}
\alias{ate}
\title{AIPW (doubly-robust) estimator for Average Treatment Effect}
\usage{
ate(
  formula,
  data = parent.frame(),
  weights,
  offset,
  family = stats::gaussian(identity),
  nuisance = NULL,
  propensity = nuisance,
  all,
  labels = NULL,
  adjust.nuisance = TRUE,
  adjust.propensity = TRUE,
  ...
)
}
\arguments{
\item{formula}{formula (see details below)}

\item{data}{data.frame}

\item{weights}{optional frequency weights}

\item{offset}{optional offset (character or vector). can also be specified in
the formula.}

\item{family}{Exponential family argument for outcome model}

\item{nuisance}{outcome regression formula (Q-model)}

\item{propensity}{propensity model formula}

\item{all}{when TRUE all standard errors are calculated (default TRUE when
exposure only has two levels)}

\item{labels}{optional treatment labels}

\item{adjust.nuisance}{adjust for uncertainty due to estimation of outcome
regression model parameters}

\item{adjust.propensity}{adjust for uncertainty due to estimation of
propensity regression model parameters}

\item{...}{additional arguments to lower level functions}
}
\value{
An object of class '\code{ate.targeted}' is returned. See
\code{\link{targeted-class}} for more details about this class and its
generic functions.
}
\description{
Augmented Inverse Probability Weighting estimator for the Average (Causal)
Treatment Effect. All nuisance models are here parametric (glm). For a more
general approach see the \code{cate} implementation. In this implementation
the standard errors are correct even when the nuisance models are
mis-specified (the influence curve is calculated including the term coming
from the parametric nuisance models). The estimate is consistent if either
the propensity model or the outcome model / Q-model is correctly specified.
}
\details{
The formula may either be specified as: response ~ treatment |
nuisance-formula | propensity-formula

For example: \code{ate(y~a | x+z+a | x*z, data=...)}

Alternatively, as a list: \code{ate(list(y~a, ~x+z, ~x*z), data=...)}

Or using the nuisance (and propensity argument):
\code{ate(y~a, nuisance=~x+z, ...)}
}
\examples{
m <- lava::lvm(y ~ a+x, a~x) |>
     lava::distribution(~y, value = lava::binomial.lvm()) |>
     lava::ordinal(K=4, ~a) |>
     transform(~a, value = factor)
d <- lava::sim(m, 1e3, seed=1)
# (a <- ate(y~a|a*x|x, data=d))
(a <- ate(y~a, nuisance=~a*x, propensity=~x, data = d))

# Comparison with randomized experiment
m0 <- lava::cancel(m, a~x)
lm(y~a-1, lava::sim(m0,2e4))

# Choosing a different contrast for the association measures
summary(a, contrast=c(2,4))
}
\seealso{
cate
}
\author{
Klaus K. Holst
}
