% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_knitr_deps_expr.R
\name{tar_knitr_deps_expr}
\alias{tar_knitr_deps_expr}
\title{Expression with literate programming dependencies.}
\usage{
tar_knitr_deps_expr(path)
}
\arguments{
\item{path}{Character vector, path to one or more R Markdown or
\code{knitr} reports.}
}
\value{
Expression object to name the dependency targets
of the \code{knitr} report, which will be detected in the
static code analysis of \code{targets}.
}
\description{
Construct an expression whose global variable dependencies
are the target dependencies of one or more literate programming reports
(R Markdown or \code{knitr}). This helps third-party developers create their
own third-party target factories for literate programming targets
(similar to \code{\link[=tar_knit]{tar_knit()}} and \code{\link[=tar_render]{tar_render()}}).
}
\examples{
lines <- c(
  "---",
  "title: report",
  "output_format: html_document",
  "---",
  "",
  "```{r}",
  "targets::tar_load(data1)",
  "targets::tar_read(data2)",
  "```"
)
report <- tempfile()
writeLines(lines, report)
tar_knitr_deps_expr(report)
}
\seealso{
Other Literate programming utilities: 
\code{\link{tar_knitr_deps}()},
\code{\link{tar_quarto_files}()}
}
\concept{Literate programming utilities}
