% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_quarto_rep.R, R/tar_quarto_rep_raw.R
\name{tar_quarto_rep}
\alias{tar_quarto_rep}
\alias{tar_quarto_rep_raw}
\title{Parameterized Quarto with dynamic branching.}
\usage{
tar_quarto_rep(
  name,
  path,
  working_directory = NULL,
  execute_params = data.frame(),
  batches = NULL,
  extra_files = character(0),
  execute = TRUE,
  cache = NULL,
  cache_refresh = FALSE,
  debug = FALSE,
  quiet = TRUE,
  quarto_args = NULL,
  pandoc_args = NULL,
  rep_workers = 1,
  tidy_eval = targets::tar_option_get("tidy_eval"),
  packages = targets::tar_option_get("packages"),
  library = targets::tar_option_get("library"),
  format = targets::tar_option_get("format"),
  iteration = targets::tar_option_get("iteration"),
  error = targets::tar_option_get("error"),
  memory = targets::tar_option_get("memory"),
  garbage_collection = targets::tar_option_get("garbage_collection"),
  deployment = targets::tar_option_get("deployment"),
  priority = targets::tar_option_get("priority"),
  resources = targets::tar_option_get("resources"),
  retrieval = targets::tar_option_get("retrieval"),
  cue = targets::tar_option_get("cue"),
  description = targets::tar_option_get("description")
)

tar_quarto_rep_raw(
  name,
  path,
  working_directory = NULL,
  execute_params = expression(NULL),
  batches = NULL,
  extra_files = character(0),
  execute = TRUE,
  cache = NULL,
  cache_refresh = FALSE,
  debug = FALSE,
  quiet = TRUE,
  quarto_args = NULL,
  pandoc_args = NULL,
  rep_workers = 1,
  packages = targets::tar_option_get("packages"),
  library = targets::tar_option_get("library"),
  format = targets::tar_option_get("format"),
  iteration = targets::tar_option_get("iteration"),
  error = targets::tar_option_get("error"),
  memory = targets::tar_option_get("memory"),
  garbage_collection = targets::tar_option_get("garbage_collection"),
  deployment = targets::tar_option_get("deployment"),
  priority = targets::tar_option_get("priority"),
  resources = targets::tar_option_get("resources"),
  retrieval = targets::tar_option_get("retrieval"),
  cue = targets::tar_option_get("cue"),
  description = targets::tar_option_get("description")
)
}
\arguments{
\item{name}{Name of the target.
\code{\link[=tar_quarto_rep]{tar_quarto_rep()}} expects an unevaluated symbol for the \code{name}
argument, and
\code{\link[=tar_quarto_rep_raw]{tar_quarto_rep_raw()}} expects a character string for \code{name}.}

\item{path}{Character string, path to the Quarto source file if rendering
a single file, or the path to the root of the project if rendering
a whole Quarto project.}

\item{working_directory}{Optional character string,
path to the working directory
to temporarily set when running the report.
The default is \code{NULL}, which runs the report from the
current working directory at the time the pipeline is run.
This default is recommended in the vast majority of cases.
To use anything other than \code{NULL}, you must manually set the value
of the \code{store} argument relative to the working directory in all calls
to \code{tar_read()} and \code{tar_load()} in the report. Otherwise,
these functions will not know where to find the data.}

\item{execute_params}{Code to generate
a data frame or \code{tibble} with one row per rendered report
and one column per Quarto parameter.
\code{\link[=tar_quarto_rep]{tar_quarto_rep()}} expects an unevaluated expression for the
\code{exectue_params} argument, whereas
\code{\link[=tar_quarto_rep_raw]{tar_quarto_rep_raw()}} expects an evaluated expression object.

You may also include an
\code{output_file} column in the parameters
to specify the path of each rendered report.
If included, the \code{output_file} column must be a character vector
with one and only one output file for each row of parameters.
If an \code{output_file} column is not included,
then the output files are automatically determined using the parameters,
and the default file format is determined by the YAML front-matter
of the Quarto source document. Only the first file format is used,
the others are not generated.
Quarto parameters must not be named \code{tar_group} or \code{output_file}.
This \code{execute_params} argument is converted into the command for a target
that supplies the Quarto parameters.}

\item{batches}{Number of batches. This is also the number of dynamic
branches created during \code{tar_make()}.}

\item{extra_files}{Character vector of extra files and
directories to track for changes. The target will be invalidated
(rerun on the next \code{tar_make()}) if the contents of these files changes.
No need to include anything already in the output of \code{\link[=tar_quarto_files]{tar_quarto_files()}},
the list of file dependencies automatically detected through
\code{quarto::quarto_inspect()}.}

\item{execute}{Whether to execute embedded code chunks.}

\item{cache}{Cache execution output (uses knitr cache and jupyter-cache
respectively for Rmd and Jupyter input files).}

\item{cache_refresh}{Force refresh of execution cache.}

\item{debug}{Leave intermediate files in place after render.}

\item{quiet}{Suppress warning and other messages.}

\item{quarto_args}{Character vector of other \code{quarto} CLI arguments to append
to the Quarto command executed by this function. This is mainly intended for
advanced usage and useful for CLI arguments which are not yet mirrored in a
dedicated parameter of this \R function. See \verb{quarto render --help} for options.}

\item{pandoc_args}{Additional command line arguments to pass on to Pandoc.}

\item{rep_workers}{Positive integer of length 1, number of local R
processes to use to run reps within batches in parallel. If 1,
then reps are run sequentially within each batch. If greater than 1,
then reps within batch are run in parallel using a PSOCK cluster.}

\item{tidy_eval}{Logical of length 1, whether to use tidy evaluation
to resolve \code{execute_params}. Similar to the \code{tidy_eval}
argument of \code{targets::tar_target()}.}

\item{packages}{Character vector of packages to load right before
the target runs or the output data is reloaded for
downstream targets. Use \code{tar_option_set()} to set packages
globally for all subsequent targets you define.}

\item{library}{Character vector of library paths to try
when loading \code{packages}.}

\item{format}{Optional storage format for the target's return value.
With the exception of \code{format = "file"}, each target
gets a file in \verb{_targets/objects}, and each format is a different
way to save and load this file. See the "Storage formats" section
for a detailed list of possible data storage formats.}

\item{iteration}{Character of length 1, name of the iteration mode
of the target. Choices:
\itemize{
\item \code{"vector"}: branching happens with \code{vectors::vec_slice()} and
aggregation happens with \code{vctrs::vec_c()}.
\item \code{"list"}, branching happens with \verb{[[]]} and aggregation happens with
\code{list()}. In the case of list iteration, \code{tar_read(your_target)}
will return a list of lists, where the outer list has one element per
batch and each inner list has one element per rep within batch.
To un-batch this nested list, call
\code{tar_read(your_target, recursive = FALSE)}.
\item \code{"group"}: \code{dplyr::group_by()}-like functionality to branch over
subsets of a data frame. The target's return value must be a data
frame with a special \code{tar_group} column of consecutive integers
from 1 through the number of groups. Each integer designates a group,
and a branch is created for each collection of rows in a group.
See the \code{tar_group()} function in \code{targets} to see how you can
create the special \code{tar_group} column with \code{dplyr::group_by()}.
}}

\item{error}{Character of length 1, what to do if the target
stops and throws an error. Options:
\itemize{
\item \code{"stop"}: the whole pipeline stops and throws an error.
\item \code{"continue"}: the whole pipeline keeps going.
\item \code{"null"}: The errored target continues and returns \code{NULL}.
The data hash is deliberately wrong so the target is not
up to date for the next run of the pipeline. In addition,
as of \code{targets} version 1.8.0.9011, a value of \code{NULL} is given
to upstream dependencies with \code{error = "null"} if loading fails.
\item \code{"abridge"}: any currently running targets keep running,
but no new targets launch after that.
\item \code{"trim"}: all currently running targets stay running. A queued
target is allowed to start if:
\enumerate{
\item It is not downstream of the error, and
\item It is not a sibling branch from the same \code{\link[targets:tar_target]{tar_target()}} call
(if the error happened in a dynamic branch).
}

The idea is to avoid starting any new work that the immediate error
impacts. \code{error = "trim"} is just like \code{error = "abridge"},
but it allows potentially healthy regions of the dependency graph
to begin running.
(Visit \url{https://books.ropensci.org/targets/debugging.html}
to learn how to debug targets using saved workspaces.)
}}

\item{memory}{Character of length 1, memory strategy. Possible values:
\itemize{
\item \code{"auto"}: new in \code{targets} version 1.8.0.9011, \code{memory = "auto"}
is equivalent to \code{memory = "transient"} for dynamic branching
(a non-null \code{pattern} argument) and \code{memory = "persistent"}
for targets that do not use dynamic branching.
\item \code{"persistent"}: the target stays in memory
until the end of the pipeline (unless \code{storage} is \code{"worker"},
in which case \code{targets} unloads the value from memory
right after storing it in order to avoid sending
copious data over a network).
\item \code{"transient"}: the target gets unloaded
after every new target completes.
Either way, the target gets automatically loaded into memory
whenever another target needs the value.
}

For cloud-based dynamic files
(e.g. \code{format = "file"} with \code{repository = "aws"}),
the \code{memory} option applies to the
temporary local copy of the file:
\code{"persistent"} means it remains until the end of the pipeline
and is then deleted,
and \code{"transient"} means it gets deleted as soon as possible.
The former conserves bandwidth,
and the latter conserves local storage.}

\item{garbage_collection}{Logical: \code{TRUE} to run \code{base::gc()}
just before the target runs,
\code{FALSE} to omit garbage collection.
In the case of high-performance computing,
\code{gc()} runs both locally and on the parallel worker.
All this garbage collection is skipped if the actual target
is skipped in the pipeline.
Non-logical values of \code{garbage_collection} are converted to \code{TRUE} or
\code{FALSE} using \code{isTRUE()}. In other words, non-logical values are
converted \code{FALSE}. For example, \code{garbage_collection = 2}
is equivalent to \code{garbage_collection = FALSE}.}

\item{deployment}{Character of length 1. If \code{deployment} is
\code{"main"}, then the target will run on the central controlling R process.
Otherwise, if \code{deployment} is \code{"worker"} and you set up the pipeline
with distributed/parallel computing, then
the target runs on a parallel worker. For more on distributed/parallel
computing in \code{targets}, please visit
\url{https://books.ropensci.org/targets/crew.html}.}

\item{priority}{Numeric of length 1 between 0 and 1. Controls which
targets get deployed first when multiple competing targets are ready
simultaneously. Targets with priorities closer to 1 get dispatched earlier
(and polled earlier in \code{\link[targets:tar_make_future]{tar_make_future()}}).}

\item{resources}{Object returned by \code{tar_resources()}
with optional settings for high-performance computing
functionality, alternative data storage formats,
and other optional capabilities of \code{targets}.
See \code{tar_resources()} for details.}

\item{retrieval}{Character string to control when the current target
loads its dependencies into memory before running.
(Here, a "dependency" is another target upstream that the current one
depends on.) Only relevant when using \code{targets}
with parallel workers (\url{https://books.ropensci.org/targets/crew.html}).
Must be one of the following values:
\itemize{
\item \code{"main"}: the target's dependencies are loaded on the host machine
and sent to the worker before the target runs.
\item \code{"worker"}: the worker loads the target's dependencies.
\item \code{"none"}: \code{targets} makes no attempt to load its
dependencies. With \code{retrieval = "none"}, loading dependencies
is the responsibility of the user. Use with caution.
}}

\item{cue}{An optional object from \code{tar_cue()} to customize the
rules that decide whether the target is up to date.}

\item{description}{Character of length 1, a custom free-form human-readable
text description of the target. Descriptions appear as target labels
in functions like \code{\link[targets:tar_manifest]{tar_manifest()}} and \code{\link[targets:tar_visnetwork]{tar_visnetwork()}},
and they let you select subsets of targets for the \code{names} argument of
functions like \code{\link[targets:tar_make]{tar_make()}}. For example,
\code{tar_manifest(names = tar_described_as(starts_with("survival model")))}
lists all the targets whose descriptions start with the character
string \code{"survival model"}.}
}
\value{
A list of target objects to render the Quarto
reports. Changes to the parameters, source file, dependencies, etc.
will cause the appropriate targets to rerun during \code{tar_make()}.
See the "Target objects" section for background.
}
\description{
Targets to render a parameterized Quarto document
with multiple sets of parameters.

\code{\link[=tar_quarto_rep]{tar_quarto_rep()}} expects an unevaluated symbol for the \code{name}
argument and an unevaluated expression for the \code{exectue_params} argument.
\code{\link[=tar_quarto_rep_raw]{tar_quarto_rep_raw()}} expects a character string for the \code{name}
argument and an evaluated expression object
for the \code{exectue_params} argument.
}
\details{
\code{tar_quarto_rep()} is an alternative to \code{tar_target()} for
a parameterized Quarto document that depends on other targets.
Parameters must be given as a data frame with one row per
rendered report and one column per parameter. An optional
\code{output_file} column may be included to set the output file path
of each rendered report. (See the \code{execute_params} argument for details.)

The Quarto source should mention other dependency targets
\code{tar_load()} and \code{tar_read()} in the active code chunks
(which also allows you to render the report
outside the pipeline if the \verb{_targets/} data store already exists
and appropriate defaults are specified for the parameters).
(Do not use \code{tar_load_raw()} or \code{tar_read_raw()} for this.)
Then, \code{tar_quarto()} defines a special kind of target. It
1. Finds all the \code{tar_load()}/\code{tar_read()} dependencies in the report
and inserts them into the target's command.
This enforces the proper dependency relationships.
(Do not use \code{tar_load_raw()} or \code{tar_read_raw()} for this.)
2. Sets \code{format = "file"} (see \code{tar_target()}) so \code{targets}
watches the files at the returned paths and reruns the report
if those files change.
3. Configures the target's command to return the output
report files: the rendered document, the source file,
and file paths mentioned in \code{files}. All these file paths
are relative paths so the project stays portable.
4. Forces the report to run in the user's current working directory
instead of the working directory of the report.
5. Sets convenient default options such as \code{deployment = "main"}
in the target and \code{quiet = TRUE} in \code{quarto::quarto_render()}.
}
\section{Target objects}{

Most \code{tarchetypes} functions are target factories,
which means they return target objects
or lists of target objects.
Target objects represent skippable steps of the analysis pipeline
as described at \url{https://books.ropensci.org/targets/}.
Please read the walkthrough at
\url{https://books.ropensci.org/targets/walkthrough.html}
to understand the role of target objects in analysis pipelines.

For developers,
\url{https://wlandau.github.io/targetopia/contributing.html#target-factories}
explains target factories (functions like this one which generate targets)
and the design specification at
\url{https://books.ropensci.org/targets-design/}
details the structure and composition of target objects.
}

\section{Replicate-specific seeds}{

In ordinary pipelines, each target has its own unique deterministic
pseudo-random number generator seed derived from its target name.
In batched replicate, however, each batch is a target with multiple
replicate within that batch. That is why \code{\link[=tar_rep]{tar_rep()}}
and friends give each \emph{replicate} its own unique seed.
Each replicate-specific seed is created
based on the dynamic parent target name,
\code{tar_option_get("seed")} (for \code{targets} version 0.13.5.9000 and above),
batch index, and rep-within-batch index.
The seed is set just before the replicate runs.
Replicate-specific seeds are invariant to batching structure.
In other words,
\code{tar_rep(name = x, command = rnorm(1), batches = 100, reps = 1, ...)}
produces the same numerical output as
\code{tar_rep(name = x, command = rnorm(1), batches = 10, reps = 10, ...)}
(but with different batch names).
Other target factories with this seed scheme are \code{\link[=tar_rep2]{tar_rep2()}},
\code{\link[=tar_map_rep]{tar_map_rep()}}, \code{\link[=tar_map2_count]{tar_map2_count()}}, \code{\link[=tar_map2_size]{tar_map2_size()}},
and \code{\link[=tar_render_rep]{tar_render_rep()}}.
For the \verb{tar_map2_*()} functions,
it is possible to manually supply your own seeds
through the \code{command1} argument and then invoke them in your
custom code for \code{command2} (\code{set.seed()}, \code{withr::with_seed},
or \code{withr::local_seed()}). For \code{\link[=tar_render_rep]{tar_render_rep()}},
custom seeds can be supplied to the \code{params} argument
and then invoked in the individual R Markdown reports.
Likewise with \code{\link[=tar_quarto_rep]{tar_quarto_rep()}} and the \code{execute_params} argument.
}

\section{Literate programming limitations}{

Literate programming files are messy and variable,
so functions like \code{\link[=tar_render]{tar_render()}} have limitations:
* Child documents are not tracked for changes.
* Upstream target dependencies are not detected if \code{tar_read()}
and/or \code{tar_load()} are called from a user-defined function.
In addition, single target names must be mentioned and they must
be symbols. \code{tar_load("x")} and \code{tar_load(contains("x"))} may not
detect target \code{x}.
* Special/optional input/output files may not be detected in all cases.
* \code{\link[=tar_render]{tar_render()}} and friends are for local files only. They do not
integrate with the cloud storage capabilities of \code{targets}.
}

\section{Quarto troubleshooting}{

If you encounter difficult errors, please read
\url{https://github.com/quarto-dev/quarto-r/issues/16}.
In addition, please try to reproduce the error using
\code{quarto::quarto_render("your_report.qmd", execute_dir = getwd())}
without using \code{targets} at all. Isolating errors this way
makes them much easier to solve.
}

\examples{
if (identical(Sys.getenv("TAR_LONG_EXAMPLES"), "true")) {
targets::tar_dir({ # tar_dir() runs code from a temporary directory.
# Parameterized Quarto:
lines <- c(
  "---",
  "title: 'report.qmd file'",
  "output_format: html_document",
  "params:",
  "  par: \"default value\"",
  "---",
  "Assume these lines are in a file called report.qmd.",
  "```{r}",
  "print(params$par)",
  "```"
)
writeLines(lines, "report.qmd") # In tar_dir(), not the user's file space.
# The following pipeline will run the report for each row of params.
targets::tar_script({
  library(tarchetypes)
  list(
    tar_quarto_rep(
      name = report,
      path = "report.qmd",
      execute_params = tibble::tibble(par = c(1, 2))
    ),
    tar_quarto_rep_raw(
      name = "report",
      path = "report.qmd",
      execute_params = quote(tibble::tibble(par = c(1, 2)))
    )
  )
}, ask = FALSE)
# Then, run the targets pipeline as usual.
})
}
}
\seealso{
Other Literate programming targets: 
\code{\link{tar_knit}()},
\code{\link{tar_quarto}()},
\code{\link{tar_render}()},
\code{\link{tar_render_rep}()}
}
\concept{Literate programming targets}
