% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sound_speed.R
\name{sound_speed}
\alias{sound_speed}
\title{Sound speed estimation}
\usage{
sound_speed(temperature, D = NULL, S = NULL)
}
\arguments{
\item{temperature}{The temperature in degrees C}

\item{D}{(optional) The depth in meters (defaults to 1 m)}

\item{S}{The salinity in part-per-thousand (defaults to 35 ppt)}
}
\value{
The sound speed in m/s
}
\description{
This function is used to estimate the sound speed using Coppens equation
}
\note{
Range of validity: temperature 0 to 35 °C, salinity 0 to 45 parts per thousand, depth 0 to 4000 m

Source: http://resource.npl.co.uk/acoustics/techguides/soundseawater/content.html#UNESCO
}
\examples{
sound_speed(8, 1000, 34)
}
