% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tadaa_pairwise_t.R
\name{tadaa_pairwise_t}
\alias{tadaa_pairwise_t}
\title{Extended Pairwise t-Tests}
\usage{
tadaa_pairwise_t(data, response, group1, group2 = NULL, p.adjust = "bonf",
  paired = FALSE, pool.sd = !paired, alternative = "two.sided",
  print = "df")
}
\arguments{
\item{data}{A \code{data.frame} containing the variables.}

\item{response}{The response variable, i.e. the dependent numeric vector.}

\item{group1}{The grouping variables, typically a \code{factor}.}

\item{group2}{(Optional) second grouping variable.}

\item{p.adjust}{The p-adjustment method, see \link[stats:p.adjust.methods]{stats::p.adjust.methods}, passed
to \link[stats:pairwise.t.test]{stats::pairwise.t.test}. Additionally, \code{sidak} is supported as a
method, which is not the case with \link[stats:p.adjust]{stats::p.adjust}, as is \code{sidakSD} for the
Sidak step-down procedure.}

\item{paired}{Defaults to \code{FALSE}, also passed to \link[stats:pairwise.t.test]{stats::pairwise.t.test}.}

\item{pool.sd}{Defaults to the inverse of \code{paired}, passed
to \link[stats:pairwise.t.test]{stats::pairwise.t.test}.}

\item{alternative}{Defaults to \code{two.sided}, also passed to \link[stats:pairwise.t.test]{stats::pairwise.t.test}.}

\item{print}{Print method, defaults to \code{df} for \code{data.frame} output, otherwise
passed to \link[pixiedust:sprinkle_print_method]{pixiedust::sprinkle_print_method}.}
}
\value{
A \code{data.frame} with columns \code{term}, \code{comparison} and \code{adj.p.value}.
}
\description{
This is an extension of \link[stats:pairwise.t.test]{stats::pairwise.t.test} that's meant to deal with
interactions our of the box, while also performing pairwise tests for the primary terms.
The output of the function is modeled after \link[stats:TukeyHSD]{stats::TukeyHSD}, unfortunately
without confidence intervals or test statistic though.
}
\note{
The adjustment method is applied within each \code{term}, meaning that the number of
pairwise t-tests counted for the adjustment is only equal to the number of rows
per \code{term} of the output.
The additional Sidak adjustment method uses the following method:
\code{p_adj <- 1 - pbinom(q = 0, size = length(p_values), prob = p_values)}
And is sometimes preferred over Bonferroni.
The Sidak-like (1987) step-down procedure (\code{sidakSD}) is an improvement
over the Holm's (1979) step-down procedure.
}
\examples{
tadaa_pairwise_t(ngo, deutsch, jahrgang, geschl, p.adjust = "none", print = "console")
tadaa_pairwise_t(ngo, deutsch, jahrgang, geschl, p.adjust = "bonf", print = "console")
tadaa_pairwise_t(ngo, deutsch, jahrgang, geschl, p.adjust = "sidak", print = "console")

}
\references{
https://stats.stackexchange.com/questions/20825/sidak-or-bonferroni

https://rdrr.io/rforge/mutoss/man/SidakSD.html
}
\seealso{
\code{\link[=tadaa_pairwise_tukey]{tadaa_pairwise_tukey()}}, \code{\link[=tadaa_pairwise_gh]{tadaa_pairwise_gh()}}

Other Tadaa-functions: \code{\link{tadaa_aov}},
  \code{\link{tadaa_chisq}}, \code{\link{tadaa_kruskal}},
  \code{\link{tadaa_levene}}, \code{\link{tadaa_nom}},
  \code{\link{tadaa_normtest}},
  \code{\link{tadaa_one_sample}}, \code{\link{tadaa_ord}},
  \code{\link{tadaa_pairwise_gh}},
  \code{\link{tadaa_pairwise_tukey}},
  \code{\link{tadaa_t.test}}, \code{\link{tadaa_wilcoxon}}
}
