% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab.R
\name{tab_prepare}
\alias{tab_prepare}
\title{Prepare data for \code{\link{tab_plain}}.}
\usage{
tab_prepare(
  data,
  row_var,
  col_vars,
  tab_vars,
  na = "keep",
  cleannames = NULL,
  rare_to_other = FALSE,
  n_min = 30,
  other_level = "Others"
)
}
\arguments{
\item{data}{A dataframe.}

\item{row_var, col_vars, tab_vars}{Variables then to be passed in \code{\link{tab_plain}}.}

\item{na}{\code{na = "keep"} prints \code{NA}'s as explicit \code{"NA"} level.
\code{na = "drop"} removes \code{NA} levels before making each table
(tabs made with different column variables may have a different number of
observations, and won't exactly have the same total columns).
\code{na = "drop_all"} first removes observations with NA in any selected variable,
for all tables (tabs for each column variable will have the same number of
observations)}

\item{cleannames}{Set to \code{TRUE} to clean levels names, by removing
prefix numbers like \code{"1-"}, and text in parentheses.}

\item{rare_to_other}{When set to \code{TRUE}, levels with less count
than \code{n_min} will be merged into an "Other" level.}

\item{n_min}{The count under which a level is aggregated in the "Other" level.}

\item{other_level}{The name of the "Other" level, as a character vector of length one.}
}
\value{
A modified data.frame.
}
\description{
Prepare data for \code{\link{tab_plain}}.
}
\examples{
\donttest{data <- dplyr::starwars \%>\%
tab_prepare(sex, hair_color, gender, rare_to_other = TRUE,
            n_min = 5, na = "keep")
data
}
}
