% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab.R
\name{tab_tot}
\alias{tab_tot}
\title{Add totals to a \code{\link[tabxplor]{tab}}}
\usage{
tab_tot(
  tabs,
  tot = c("row", "col"),
  name = "Total",
  totcol = "last",
  data = NULL
)
}
\arguments{
\item{tabs}{A \code{tibble} of class \code{tab}, made with \code{\link{tab_core}} or
\code{\link{tab_many}}.}

\item{tot}{\code{c("col", "row")} and \code{"both"} print total rows and total columns.
Set to \code{"row"} or \code{"col"} to print only one type.
Set to \code{"no"} to remove all totals.}

\item{name}{The names of the totals, as a character vector of length one or two.
Use \code{c("Total_row", "Total_column")} to set different names for rows and cols.}

\item{totcol}{\code{"last"} only prints a total column for the last factor column
variable. Set to \code{"each"} to print a total column for each column variable.}

\item{data}{The original database used to calculate the \code{tab} : it is only useful
for mean columns (of numeric variables), in order to calculate the variances of
total rows, necessary to calculate confidence intervals with \code{\link{tab_ci}}.}
}
\value{
A \code{tibble} of class \code{tab}. Total rows can then be detected using
\code{\link{is_totrow}}, and total columns using \code{\link{is_totcol}}.
}
\description{
Add totals to a \code{\link[tabxplor]{tab}}
}
\examples{
\donttest{data <- dplyr::starwars \%>\% tab_prepare(sex, hair_color)

data \%>\%
  tab_core(sex, hair_color) \%>\%
  tab_tot("col", totcol = "each")
  }
}
