% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_classes.R
\name{tab_kable}
\alias{tab_kable}
\title{Print a tabxplor table in html}
\usage{
tab_kable(tabs, theme = c("light", "dark"), color_type = NULL, ...)
}
\arguments{
\item{tabs}{A table made with \code{\link{tab}} or \code{\link{tab_many}}.}

\item{theme}{By default, a white table with black text, Set to \code{"dark"} for a
black table with white text.}

\item{color_type}{Set to \code{"text"} to color the text, \code{"bg"} to color the
background. By default it takes \code{getOption("tabxplor.color_style_type")}.}

\item{...}{Other arguments to pass to
\code{\link[kableExtra:kable_styling]{kableExtra::kable_styling}}.}
}
\value{
A html table (opened in the viewer in RStudio). Differences from totals,
confidence intervals, contribution to variance, and unweighted counts,
are available in an html tooltip at cells hover.
}
\description{
Print a tabxplor table in html
}
\examples{
\donttest{
tabs <- tab(forcats::gss_cat, race, marital, year, pct = "row", color = "diff")
tab_kable(tabs, theme = "light", color_type = "text")
}

}
