/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.jbig2.image;

import com.levigo.jbig2.Bitmap;
import com.levigo.jbig2.image.BitmapScanline;
import com.levigo.jbig2.image.Filter;
import com.levigo.jbig2.image.ParameterizedFilter;
import com.levigo.jbig2.image.Scanline;
import com.levigo.jbig2.image.Weighttab;
import com.levigo.jbig2.util.Utils;
import java.awt.Rectangle;
import java.awt.image.WritableRaster;

class Resizer {
    private static final double EPSILON = 1.0E-7;
    private int weightBits = 14;
    private int weightOne = 1 << this.weightBits;
    private int[] bitsPerChannel = new int[]{8, 8, 8};
    private static final int[] NO_SHIFT = new int[16];
    private int[] finalShift = new int[]{2 * this.weightBits - this.bitsPerChannel[0], 2 * this.weightBits - this.bitsPerChannel[1], 2 * this.weightBits - this.bitsPerChannel[2]};
    static final boolean debug = false;
    private final boolean coerce = true;
    private final Order order = Order.AUTO;
    private final boolean trimZeros = true;
    private final Mapping mappingX;
    private final Mapping mappingY;

    private static boolean isInteger(double d) {
        return Math.abs(d - Math.floor(d + 0.5)) < 1.0E-7;
    }

    public Resizer(double d) {
        this(d, d);
    }

    public Resizer(double d, double d2) {
        this.mappingX = new Mapping(d);
        this.mappingY = new Mapping(d2);
    }

    private Weighttab[] createXWeights(Rectangle rectangle, Rectangle rectangle2, ParameterizedFilter parameterizedFilter) {
        int n = rectangle.x;
        int n2 = rectangle.x + rectangle.width;
        int n3 = rectangle2.x;
        int n4 = rectangle2.x + rectangle2.width;
        Weighttab[] weighttabArray = new Weighttab[rectangle2.width];
        for (int i = n3; i < n4; ++i) {
            double d = this.mappingX.mapPixelCenter(i);
            weighttabArray[i - n3] = new Weighttab(parameterizedFilter, this.weightOne, d, n, n2 - 1, true);
        }
        return weighttabArray;
    }

    private ParameterizedFilter simplifyFilter(ParameterizedFilter parameterizedFilter, double d, double d2) {
        if (parameterizedFilter.support <= 0.5 || parameterizedFilter.filter.cardinal && Resizer.isInteger(1.0 / parameterizedFilter.scale) && Resizer.isInteger(1.0 / (d * parameterizedFilter.scale)) && Resizer.isInteger((d2 / d - 0.5) / parameterizedFilter.scale)) {
            return new ParameterizedFilter(new Filter.Point(), 1.0, 0.5, 1);
        }
        return parameterizedFilter;
    }

    private void resizeXfirst(Object object, Rectangle rectangle, Object object2, Rectangle rectangle2, ParameterizedFilter parameterizedFilter, ParameterizedFilter parameterizedFilter2) {
        int n;
        Scanline scanline = Resizer.createScanline(object, object2, rectangle.width);
        Scanline scanline2 = Resizer.createScanline(object, object2, rectangle2.width);
        Weighttab[] weighttabArray = this.createXWeights(rectangle, rectangle2, parameterizedFilter);
        int n2 = parameterizedFilter2.width + 2;
        Scanline[] scanlineArray = new Scanline[n2];
        for (n = 0; n < n2; ++n) {
            scanlineArray[n] = Resizer.createScanline(object, object2, rectangle2.width);
            scanlineArray[n].y = -1;
        }
        n = rectangle.y;
        int n3 = rectangle.y + rectangle.height;
        int n4 = rectangle2.y;
        int n5 = rectangle2.y + rectangle2.height;
        int n6 = -1;
        for (int i = n4; i < n5; ++i) {
            Weighttab weighttab = new Weighttab(parameterizedFilter2, this.weightOne, this.mappingY.mapPixelCenter(i), n, n3 - 1, true);
            scanline2.clear();
            for (int j = weighttab.i0; j <= weighttab.i1; ++j) {
                Scanline scanline3 = scanlineArray[j % n2];
                if (scanline3.y != j) {
                    scanline3.y = j;
                    if (n + j <= n6) {
                        throw new AssertionError((Object)("Backtracking from line " + n6 + " to " + (n + j)));
                    }
                    scanline.fetch(rectangle.x, n + j);
                    n6 = n + j;
                    scanline.filter(NO_SHIFT, this.bitsPerChannel, weighttabArray, scanline3);
                }
                scanline3.accumulate(weighttab.weights[j - weighttab.i0], scanline2);
            }
            scanline2.shift(this.finalShift);
            scanline2.store(rectangle2.x, i);
        }
    }

    private void resizeYfirst(Object object, Rectangle rectangle, Object object2, Rectangle rectangle2, ParameterizedFilter parameterizedFilter, ParameterizedFilter parameterizedFilter2) {
        int n;
        Scanline scanline = Resizer.createScanline(object, object2, rectangle2.width);
        Scanline scanline2 = Resizer.createScanline(object, object2, rectangle.width);
        Weighttab[] weighttabArray = this.createXWeights(rectangle, rectangle2, parameterizedFilter);
        int n2 = parameterizedFilter2.width + 2;
        Scanline[] scanlineArray = new Scanline[n2];
        for (n = 0; n < n2; ++n) {
            scanlineArray[n] = Resizer.createScanline(object, object2, rectangle.width);
            scanlineArray[n].y = -1;
        }
        n = rectangle.y;
        int n3 = rectangle.y + rectangle.height;
        int n4 = rectangle2.y;
        int n5 = rectangle2.y + rectangle2.height;
        int n6 = -1;
        for (int i = n4; i < n5; ++i) {
            Weighttab weighttab = new Weighttab(parameterizedFilter2, this.weightOne, this.mappingY.mapPixelCenter(i), n, n3 - 1, true);
            scanline2.clear();
            for (int j = weighttab.i0; j <= weighttab.i1; ++j) {
                Scanline scanline3 = scanlineArray[j % n2];
                if (scanline3.y != j) {
                    scanline3.y = j;
                    if (n + j <= n6) {
                        throw new AssertionError((Object)("Backtracking from line " + n6 + " to " + (n + j)));
                    }
                    scanline3.fetch(rectangle.x, n + j);
                    n6 = n + j;
                }
                scanline3.accumulate(weighttab.weights[j - weighttab.i0], scanline2);
            }
            scanline2.filter(this.bitsPerChannel, this.finalShift, weighttabArray, scanline);
            scanline.store(rectangle2.x, i);
        }
    }

    public void resize(Object object, Rectangle rectangle, Object object2, Rectangle rectangle2, Filter filter, Filter filter2) {
        boolean bl;
        ParameterizedFilter parameterizedFilter = new ParameterizedFilter(filter, this.mappingX.scale);
        ParameterizedFilter parameterizedFilter2 = new ParameterizedFilter(filter2, this.mappingY.scale);
        Rectangle rectangle3 = new Rectangle();
        int n = Utils.ceil(this.mappingX.srcToDst((double)rectangle.x - parameterizedFilter.support) + 1.0E-7);
        int n2 = Utils.ceil(this.mappingY.srcToDst((double)rectangle.y - parameterizedFilter2.support) + 1.0E-7);
        int n3 = Utils.floor(this.mappingX.srcToDst((double)(rectangle.x + rectangle.width) + parameterizedFilter.support) - 1.0E-7);
        int n4 = Utils.floor(this.mappingY.srcToDst((double)(rectangle.y + rectangle.height) + parameterizedFilter2.support) - 1.0E-7);
        rectangle3.setFrameFromDiagonal(n, n2, n3, n4);
        if (rectangle2.x < rectangle3.x || rectangle2.getMaxX() > rectangle3.getMaxX() || rectangle2.y < rectangle3.y || rectangle2.getMaxY() > rectangle3.getMaxY()) {
            rectangle2 = rectangle2.intersection(rectangle3);
        }
        if (rectangle.isEmpty() || rectangle2.width <= 0 || rectangle2.height <= 0) {
            return;
        }
        parameterizedFilter = this.simplifyFilter(parameterizedFilter, this.mappingX.scale, this.mappingX.offset);
        parameterizedFilter2 = this.simplifyFilter(parameterizedFilter2, this.mappingY.scale, this.mappingY.offset);
        boolean bl2 = this.order != Order.AUTO ? this.order == Order.XY : (bl = rectangle2.width * (rectangle.height * parameterizedFilter.width + rectangle2.height * parameterizedFilter2.width) < rectangle2.height * (rectangle2.width * parameterizedFilter.width + rectangle.width * parameterizedFilter2.width));
        if (bl) {
            this.resizeXfirst(object, rectangle, object2, rectangle2, parameterizedFilter, parameterizedFilter2);
        } else {
            this.resizeYfirst(object, rectangle, object2, rectangle2, parameterizedFilter, parameterizedFilter2);
        }
    }

    private static Scanline createScanline(Object object, Object object2, int n) {
        if (object == null) {
            throw new IllegalArgumentException("src must not be null");
        }
        if (!(object instanceof Bitmap)) {
            throw new IllegalArgumentException("src must be from type " + Bitmap.class.getName());
        }
        if (object2 == null) {
            throw new IllegalArgumentException("dst must not be null");
        }
        if (!(object2 instanceof WritableRaster)) {
            throw new IllegalArgumentException("dst must be from type " + WritableRaster.class.getName());
        }
        return new BitmapScanline((Bitmap)object, (WritableRaster)object2, n);
    }

    private static enum Order {
        AUTO,
        XY,
        YX;

    }

    static final class Mapping {
        final double scale;
        final double offset = 0.5;
        private final double a0;
        private final double b0;

        Mapping(double d, double d2, double d3, double d4) {
            this.a0 = d;
            this.b0 = d3;
            this.scale = d4 / d2;
            if (this.scale <= 0.0) {
                throw new IllegalArgumentException("Negative scales are not allowed");
            }
        }

        Mapping(double d) {
            this.scale = d;
            this.b0 = 0.0;
            this.a0 = 0.0;
        }

        double mapPixelCenter(int n) {
            return ((double)n + 0.5 - this.b0) / this.scale + this.a0;
        }

        double dstToSrc(double d) {
            return (d - this.b0) / this.scale + this.a0;
        }

        double srcToDst(double d) {
            return (d - this.a0) * this.scale + this.b0;
        }
    }
}

