% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/statistics.R
\docType{methods}
\name{independance}
\alias{independance}
\alias{eppm}
\alias{eppm-method}
\alias{pvi}
\alias{pvi-method}
\alias{eppm,CountMatrix-method}
\alias{pvi,CountMatrix-method}
\title{Independance}
\usage{
eppm(object, ...)

pvi(object, ...)

\S4method{eppm}{CountMatrix}(object)

\S4method{pvi}{CountMatrix}(object)
}
\arguments{
\item{object}{A \linkS4class{CountMatrix} object.}

\item{...}{Currently not used.}
}
\value{
A \code{\link{numeric}} matrix.
}
\description{
Independance
}
\details{
Computes for each cell of a numeric matrix one of the following statistic.
}
\section{EPPM}{

 This positive difference from the column mean percentage (in french "écart
 positif au pourcentage moyen", EPPM) represents a deviation from the
 situation of statistical independence. As independence can be interpreted as
 the absence of relationships between types and the chronological order of
 the assemblages, \code{EPPM} is a useful graphical tool to explore
 significance of relationship between rows and columns related to
 seriation (Desachy 2004).
}

\section{PVI}{

 \code{PVI} is calculated for each cell as the percentage to the column
 theoretical independence value: \code{PVI} greater than \eqn{1} represent
 positive deviations from the independence, whereas \code{PVI} smaller than
 \eqn{1} represent negative deviations (Desachy 2004).

 The \code{PVI} matrix allows to explore deviations from independence
 (an intuitive graphical approach to \eqn{\chi^2}{Chi-squared}),
 in such a way that a high-contrast matrix has quite significant deviations,
 with a low risk of being due to randomness (Desachy 2004).
}

\examples{
## Abundance data
## Coerce dataset to a count matrix (data from Desachy 2004)
data("compiegne", package = "folio")
counts <- as_count(compiegne)

## Compute EPPM
counts_eppm <- eppm(counts)

## Compute PVI
counts_pvi <- pvi(counts)
plot_heatmap(counts_eppm)
}
\references{
Desachy, B. (2004). Le sériographe EPPM: un outil informatisé de sériation
 graphique pour tableaux de comptages. \emph{Revue archéologique de
 Picardie}, 3(1), 39-56. \doi{10.3406/pica.2004.2396}.
}
\seealso{
\link{plot_ford}, \link{plot_heatmap}, \link{seriate_rank}

Other statistics: 
\code{\link{test_diversity}()},
\code{\link{test_fit}()}
}
\author{
N. Frerebeau
}
\concept{statistics}
