% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/extract.R
\docType{class}
\name{DateModel-class}
\alias{DateModel-class}
\alias{[[,DateModel-method}
\alias{[,DateModel-method}
\title{Date model}
\usage{
\S4method{[[}{DateModel}(x, i)

\S4method{[}{DateModel}(x, i, j, drop = TRUE)
}
\arguments{
\item{x}{A \code{DateModel} object from which to extract element(s).}

\item{i, j}{Indices specifying elements to extract.
\code{i} is a \code{\link{character}} string matching to the name of a slot.
\code{j} can be \code{\link{missing}} or \code{\link{NULL}},
a \code{\link{numeric}} or \code{\link{character}} vector.
Numeric values are coerced to \code{\link{integer}} as by
\code{\link{as.integer}} (and hence truncated towards zero).
Character vectors will be matched to the names of the object.}

\item{drop}{A \code{\link{logical}} scalar: should the result be coerced to
the lowest possible dimension?}
}
\description{
An S4 class to store the event and accumulation times of archaeological
 assemblages as well as the results of resampling methods for date model
 checking.
}
\section{Methods (by generic)}{
\itemize{
\item \code{[[}: Extracts informations from a slot selected by subscript
\code{i}.

\item \code{[}: Allows to select a slot thru \code{j}.
}}

\section{Slots}{

\describe{
\item{\code{counts}}{A numeric matrix of count data.}

\item{\code{dates}}{A two columns \code{\link{data.frame}} giving the known dates
used for model fitting and an identifier to link each row to an assemblage.}

\item{\code{level}}{A length-one \code{\link{numeric}} vector giving the
confidence level.}

\item{\code{model}}{A \code{\link[stats:lm]{multiple linear model}}: the Gaussian
multiple linear regression model fitted for event date estimation and
prediction.}

\item{\code{residual}}{A length-one \code{\link{numeric}} vector giving the residual
standard deviation.}

\item{\code{rows}}{A five columns \code{\link{data.frame}} giving the predicted event
dates for each archaeological assemblage, with the following columns:
\describe{
 \item{id}{An identifier to link each row to an assemblage.}
 \item{estimation}{The event date estimation.}
 \item{earliest}{The lower boundary of the confidence interval.}
 \item{latest}{The upper boundary of the confidence interval.}
 \item{error}{The standard error of predicted dates.}
}}

\item{\code{columns}}{A five columns \code{\link{data.frame}} giving the predicted
event dates for each archaeological type or fabric, with the following
columns:
\describe{
 \item{id}{An identifier to link each row to an assemblage.}
 \item{estimation}{The event date estimation.}
 \item{earliest}{The lower boundary of the confidence interval.}
 \item{latest}{The upper boundary of the confidence interval.}
 \item{error}{The standard error of predicted dates.}
}}

\item{\code{accumulation}}{A two columns \code{\link{data.frame}} giving the point
estimate of accumulation dates of archaeological assemblages and an
identifier to link each row to an assemblage.}

\item{\code{jackknife}}{A six columns \code{\link{data.frame}} giving the results of
the resamping procedure (jackknifing fabrics) for each assemblage (in rows)
with the following columns:
\describe{
 \item{id}{An identifier to link each row to an assemblage.}
 \item{estimation}{The jackknife event date estimate.}
 \item{earliest}{The lower boundary of the associated prediction interval.}
 \item{latest}{The upper boundary of the associated prediction interval.}
 \item{error}{The standard error of predicted means.}
 \item{bias}{The jackknife estimate of bias.}
}}

\item{\code{bootstrap}}{A six columns \code{\link{data.frame}} giving the boostrap
distribution statistics for each replicated assemblage (in rows)
with the following columns:
\describe{
 \item{id}{An identifier to link each row to an assemblage.}
 \item{min}{Minimum value.}
 \item{Q05}{Sample quantile to 0.05 probability.}
 \item{mean}{Mean value (event date).}
 \item{Q95}{Sample quantile to 0.95 probability.}
 \item{max}{Maximum value.}
}}
}}

\author{
N. Frerebeau
}
