% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schema.R
\docType{class}
\name{Schema}
\alias{Schema}
\title{Schema class}
\format{\code{\link{R6Class}} object.}
\usage{
# Schema.load(descriptor, strict=FALSE)
}
\value{
Object of \code{\link{R6Class}} .
}
\description{
A model of a schema with helpful methods for working with the schema and supported data. 
Schema instances can be initialized with a schema source as a url to a JSON file or a JSON object. 
The schema is initially validated (see \href{https://github.com/okgreece/tableschema-r#validate}{validate}). 
By default validation errors will be stored in \code{$errors} but in a strict mode it will be instantly raised.
}
\section{Methods}{

\describe{

\item{\code{Schema$new(descriptor = descriptor, strict = strict)}}{
Use \code{\link{Schema.load}} to instantiate \code{Schema} class.}

  \item{\code{getField(name)}}{
Get schema field by name.}
\itemize{
 \item{\code{name }}{String with schema field name.}  
 \item{\code{(Field/NULL) }}{Returns \code{Field} instance or \code{NULL} if not found.}
 }
 
\item{\code{addField(descriptor)}}{
Add new field to schema. The schema descriptor will be validated with newly added field descriptor.}
\itemize{
 \item{\code{descriptor }}{List of field descriptor.}  
 \item{\code{TableSchemaError }}{Raises any error occured in the process.}
 \item{\code{(Field/NULL) }}{Returns added \code{Field} instance or \code{NULL} if not added.}
 }
 
\item{\code{removeField(name)}}{
Remove field resource by name. The schema descriptor will be validated after field descriptor removal.}
\itemize{
 \item{\code{name }}{String with schema field name.}  
 \item{\code{TableSchemaError }}{Raises any error occured in the process.}
 \item{\code{(Field/NULL) }}{Returns removed \code{Field} instances or \code{NULL} if not found.}
 }  
 
\item{\code{castRow(row)}}{
Cast row based on field types and formats.}
\itemize{
 \item{\code{row }}{Data row as a list of values.}  
 \item{\code{(any) }}{Returns cast data row.}
 }

\item{\code{infer(rows, headers=1)}}{
Cast row based on field types and formats.}
\itemize{
 \item{\code{rows }}{List of lists representing rows.}  
 \item{\code{headers }}{ data sample headers, one of:
 \itemize{
 \item{row number containing headers (\code{rows} should contain headers rows)}
 \item{list of headers (\code{rows} should NOT contain headers rows)}}
 }
 \item{\code{{Object} }}{Returns Table Schema descriptor.}
 }
 
\item{\code{commit(strict)}}{
Cast row based on field types and formats.}
\itemize{
 \item{\code{strict }}{Boolean, alter strict mode for further work.}  
 \item{\code{TableSchemaError }}{Raises any error occured in the process.}
 \item{\code{(Boolean) }}{Returns \code{TRUE} on success and \code{FALSE} if not modified.}
 }
 
 
\item{\code{save(target)}}{
Cast row based on field types and formats.}
\itemize{
 \item{\code{target }}{String, path where to save a descriptor.}  
 \item{\code{TableSchemaError }}{Raises any error occured in the process.}
 \item{\code{(Boolean) }}{Returns \code{TRUE} on success.}
 }  
}
}

\section{Properties}{

\describe{
  \item{\code{valid}}{Returns validation status. It always \code{TRUE} in strict mode.}
  \item{\code{errors}}{Returns validation errors. It always empty in strict mode.}
  \item{\code{descriptor}}{Returns list of schema descriptor.}
  \item{\code{primaryKey}}{Returns string list of schema primary key.}
  \item{\code{foreignKeys}}{Returns list of schema foreign keys.}
  \item{\code{fields}}{Returns list of \code{Field} instances.}
  \item{\code{fieldNames}}{Returns a list of field names.}
}
}

\section{Language}{

The key words \code{MUST}, \code{MUST NOT}, \code{REQUIRED}, \code{SHALL}, \code{SHALL NOT}, 
\code{SHOULD}, \code{SHOULD NOT}, \code{RECOMMENDED}, \code{MAY}, and \code{OPTIONAL} 
in this package documents are to be interpreted as described in \href{https://www.ietf.org/rfc/rfc2119.txt}{RFC 2119}.
}

\seealso{
\code{\link{Schema.load}}, 
\href{http://frictionlessdata.io/specs/table-schema/}{Table Schema Specifications}
}
\keyword{data}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Schema$new()}}
\item \href{#method-getField}{\code{Schema$getField()}}
\item \href{#method-addField}{\code{Schema$addField()}}
\item \href{#method-removeField}{\code{Schema$removeField()}}
\item \href{#method-castRow}{\code{Schema$castRow()}}
\item \href{#method-infer}{\code{Schema$infer()}}
\item \href{#method-commit}{\code{Schema$commit()}}
\item \href{#method-save}{\code{Schema$save()}}
\item \href{#method-clone}{\code{Schema$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Schema$new(descriptor = "{}", strict = FALSE, caseInsensitiveHeaders = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{descriptor}}{schema descriptor, a JSON string, URL or file}

\item{\code{strict}}{flag to alter validation behaviour:
\itemize{
\item{if \code{FALSE} error will not be raised and all error will be collected in \code{schema$errors}}
\item{if \code{TRUE} any validation error will be raised immediately}
}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getField"></a>}}
\subsection{Method \code{getField()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Schema$getField(fieldName, index = 1)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addField"></a>}}
\subsection{Method \code{addField()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Schema$addField(descriptor)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{descriptor}}{schema descriptor, a JSON string, URL or file}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-removeField"></a>}}
\subsection{Method \code{removeField()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Schema$removeField(name)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-castRow"></a>}}
\subsection{Method \code{castRow()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Schema$castRow(items, failFast = FALSE, skipConstraints = FALSE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-infer"></a>}}
\subsection{Method \code{infer()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Schema$infer(rows, headers = 1)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-commit"></a>}}
\subsection{Method \code{commit()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Schema$commit(strict = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{strict}}{flag to alter validation behaviour:
\itemize{
\item{if \code{FALSE} error will not be raised and all error will be collected in \code{schema$errors}}
\item{if \code{TRUE} any validation error will be raised immediately}
}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-save"></a>}}
\subsection{Method \code{save()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Schema$save(target)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Schema$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
