% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures.R
\name{dmean}
\alias{dmean}
\alias{dsd}
\title{Summarization of location and spread between synthetic and real data}
\usage{
dmean(synth, real, tol = 1e-08, ...)

dsd(synth, real, tol = 1e-08, ...)
}
\arguments{
\item{synth}{\code{[data.frame]} Synthetic data}

\item{real}{\code{[data.frame]} Real data}

\item{tol}{\code{[numeric]} Nonnegative tolerance. If the absolute 
mean (standard deviation) of a variable is smaller than 
\code{tol}, it is considered zero. In that case the 
absolute difference instead of the absolute relative 
difference is computed.}

\item{...}{Arguments passed to \code{mean}. e.g. use \code{trim=c(0.01,0.99)}
for mean estimation that is less sensitive to outliers.}
}
\description{
For each numerical variable in the two datasets, compute the relative
difference between the mean (standard deviation) of the real data and the
mean (standard deviation) of the synthetic data. The summary is the average
of these relative differences over all numerical variables.
}
\note{
Real and synthetic data are expected to have the same column names,
orders, and data types.
}
\examples{

dmean(cars, cars) # 0
dmean(synthesize(cars), cars)

dsd(cars, cars) # 0
dsd(synthesize(cars), cars)


}
\seealso{
Other measures: 
\code{\link{dcor}()},
\code{\link{pmse}()},
\code{\link{qa}()}

Other measures: 
\code{\link{dcor}()},
\code{\link{pmse}()},
\code{\link{qa}()}
}
\concept{measures}
