% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull_geo_mobility.R
\name{pull_geo_mobility}
\alias{pull_geo_mobility}
\title{Pull ACS geographic mobility data}
\usage{
pull_geo_mobility(endyear, span, geography)
}
\arguments{
\item{endyear}{An integer, indicating the latest year of the data in the survey.}

\item{span}{An integer in \code{c(1,3,5)} indicating the span of the desired data.}

\item{geography}{a valid \code{geo.set} object specifying the census geography or 
geographies to be fetched.}
}
\value{
A \code{list} containing the endyear, span, a \code{data.frame} of estimates,
a \code{data.frame} of standard errors, a character vector of the original column names,
and a \code{data.frame} of the geography metadata from \code{\link[acs]{acs.fetch}}.
}
\description{
Pull ACS data for a specified geography from base tables
B07001, B07003, B07008, B07009, B07010, and B07012.
These tables provide data on geographic mobility in the past year by a number of slices.
Additional fields, mainly percentages and aggregations, are calculated.
}
\seealso{
\code{\link[acs]{acs.fetch}}, \code{\link[acs]{geo.make}}
}

