/*
 * Decompiled with CFR 0.152.
 */
package blbutil;

import blbutil.ByteIndexArray;
import blbutil.CharIndexArray;
import blbutil.ShiftedByteIndexArray;
import blbutil.WrappedIntArray;
import java.util.Arrays;

public interface IntArray {
    public int size();

    public int get(int var1);

    public String toString();

    default public String asString() {
        int[] nArray = new int[this.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.get(i);
        }
        return Arrays.toString(nArray);
    }

    public static IntArray create(int[] nArray, int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException("min > max");
        }
        if (n >= 0) {
            if (n2 < 128) {
                return new ByteIndexArray(nArray);
            }
            if (n2 < 256) {
                return new ShiftedByteIndexArray(nArray);
            }
            if (n2 < 65536) {
                return new CharIndexArray(nArray);
            }
        }
        return new WrappedIntArray(nArray);
    }
}

