/*
 * Decompiled with CFR 0.152.
 */
package sample;

public class TrioNodes {
    private final double loadFactor = 0.75;
    private int size = 0;
    private int maxSize = 1024;
    private int rehashThreshold = (int)(0.75 * (double)this.maxSize);
    private int[] index = new int[this.maxSize];
    private int[] nodeA1 = new int[this.maxSize];
    private int[] nodeA2 = new int[this.maxSize];
    private int[] nodeB1 = new int[this.maxSize];
    private int[] nodeB2 = new int[this.maxSize];
    private double[] value = new double[this.maxSize];

    private static int hash1(int n, int n2, int n3, int n4) {
        int n5 = 5;
        n5 = 71 * n5 + n;
        n5 = 71 * n5 + n2;
        n5 = 71 * n5 + n3;
        n5 = 71 * n5 + n4;
        return n5;
    }

    private static int hash2(int n, int n2, int n3, int n4) {
        int n5 = 7;
        n5 = 97 * n5 + n;
        n5 = 97 * n5 + n2;
        n5 = 97 * n5 + n3;
        n5 = 97 * n5 + n4;
        return n5;
    }

    private int index(int n, int n2, int n3, int n4) {
        int n5 = TrioNodes.hash1(n, n2, n3, n4);
        int n6 = TrioNodes.hash2(n, n2, n3, n4);
        if ((n6 & 1) == 0) {
            ++n6;
        }
        for (int i = 0; i < this.maxSize; ++i) {
            int n7 = (n5 + i * n6) % this.maxSize;
            if (n7 < 0) {
                n7 = -n7;
            }
            if (this.value[n7] != 0.0 && (this.nodeA1[n7] != n || this.nodeA2[n7] != n2 || this.nodeB1[n7] != n3 || this.nodeB2[n7] != n4)) continue;
            return n7;
        }
        assert (false);
        return -1;
    }

    private void rehash() {
        assert (this.size >= this.rehashThreshold);
        int n = 2 * this.maxSize;
        if (n < 0) {
            throw new IllegalStateException("hash table overflow");
        }
        int[] nArray = this.index;
        int[] nArray2 = this.nodeA1;
        int[] nArray3 = this.nodeA2;
        int[] nArray4 = this.nodeB1;
        int[] nArray5 = this.nodeB2;
        double[] dArray = this.value;
        this.maxSize = n;
        this.index = new int[n];
        this.nodeA1 = new int[n];
        this.nodeA2 = new int[n];
        this.nodeB1 = new int[n];
        this.nodeB2 = new int[n];
        this.value = new double[n];
        for (int i = 0; i < this.size; ++i) {
            int n2;
            int n3 = nArray[i];
            this.index[i] = n2 = this.index(nArray2[n3], nArray3[n3], nArray4[n3], nArray5[n3]);
            this.nodeA1[n2] = nArray2[n3];
            this.nodeA2[n2] = nArray3[n3];
            this.nodeB1[n2] = nArray4[n3];
            this.nodeB2[n2] = nArray5[n3];
            this.value[n2] = dArray[n3];
        }
        this.rehashThreshold = (int)(0.75 * (double)this.maxSize);
    }

    public void maxUpdate(int n, int n2, int n3, int n4, double d) {
        if (d > 0.0) {
            int n5 = this.index(n, n2, n3, n4);
            if (this.value[n5] > 0.0) {
                if (d > this.value[n5]) {
                    this.value[n5] = d;
                }
            } else {
                this.index[this.size++] = n5;
                this.nodeA1[n5] = n;
                this.nodeA2[n5] = n2;
                this.nodeB1[n5] = n3;
                this.nodeB2[n5] = n4;
                this.value[n5] = d;
                if (this.size >= this.rehashThreshold) {
                    this.rehash();
                }
            }
        } else if (!(d >= 0.0)) {
            throw new IllegalArgumentException(String.valueOf(d));
        }
    }

    public void sumUpdate(int n, int n2, int n3, int n4, double d) {
        if (d > 0.0) {
            int n5 = this.index(n, n2, n3, n4);
            if (this.value[n5] > 0.0) {
                int n6 = n5;
                this.value[n6] = this.value[n6] + d;
            } else {
                this.index[this.size++] = n5;
                this.nodeA1[n5] = n;
                this.nodeA2[n5] = n2;
                this.nodeB1[n5] = n3;
                this.nodeB2[n5] = n4;
                int n7 = n5;
                this.value[n7] = this.value[n7] + d;
                if (this.size > this.rehashThreshold) {
                    this.rehash();
                }
            }
        } else if (!(d >= 0.0)) {
            throw new IllegalArgumentException(String.valueOf(d));
        }
    }

    public int size() {
        return this.size;
    }

    private void checkSize(int n) {
        if (n >= this.size()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
    }

    public int enumNodeA1(int n) {
        this.checkSize(n);
        return this.nodeA1[this.index[n]];
    }

    public int enumNodeA2(int n) {
        this.checkSize(n);
        return this.nodeA2[this.index[n]];
    }

    public int enumNodeB1(int n) {
        this.checkSize(n);
        return this.nodeB1[this.index[n]];
    }

    public int enumNodeB2(int n) {
        this.checkSize(n);
        return this.nodeB2[this.index[n]];
    }

    public double enumValue(int n) {
        this.checkSize(n);
        return this.value[this.index[n]];
    }

    public double value(int n, int n2, int n3, int n4) {
        return this.value[this.index(n, n2, n3, n4)];
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.value[this.index[i]] = 0.0;
        }
        this.size = 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append("size=");
        stringBuilder.append(this.size);
        for (int i = 0; i < this.size; ++i) {
            stringBuilder.append(" (");
            stringBuilder.append(i);
            stringBuilder.append(": nodeA1=");
            stringBuilder.append(this.enumNodeA1(i));
            stringBuilder.append(" nodeA2=");
            stringBuilder.append(this.enumNodeA2(i));
            stringBuilder.append(" nodeB1=");
            stringBuilder.append(this.enumNodeB1(i));
            stringBuilder.append(" nodeB2=");
            stringBuilder.append(this.enumNodeB2(i));
            stringBuilder.append(" value=");
            stringBuilder.append(this.enumValue(i));
            stringBuilder.append(") ");
        }
        return stringBuilder.toString();
    }
}

