% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Install.R
\docType{methods}
\name{install_packages}
\alias{install_packages}
\alias{install_packages,character,character-method}
\alias{install_packages,character,character}
\alias{install_packages,character,missing-method}
\alias{install_packages,character,missing}
\alias{install_packages,SessionManifest,ANY-method}
\alias{install_packages,SessionManifest,ANY}
\alias{install_packages,character,SessionManifest-method}
\alias{install_packages,character,SessionManifest}
\alias{install_packages,character,PkgManifest-method}
\alias{install_packages,character,PkgManifest}
\title{install_packages}
\usage{
install_packages(pkgs, repos, versions = NULL, verbose = FALSE, ...)

\S4method{install_packages}{character,character}(pkgs, repos,
  versions = NULL, verbose = FALSE, ...)

\S4method{install_packages}{character,missing}(pkgs, repos,
  versions = NULL, verbose = FALSE, ...)

\S4method{install_packages}{SessionManifest,ANY}(pkgs, repos,
  versions = NULL, verbose = FALSE, ...)

\S4method{install_packages}{character,SessionManifest}(pkgs, repos,
  versions = NULL, verbose = FALSE, ...)

\S4method{install_packages}{character,PkgManifest}(pkgs, repos,
  versions = NULL, verbose = FALSE, ...)
}
\arguments{
\item{pkgs}{The names of the packages to install}

\item{repos}{The (generalized) repositor(ies) to install the packages from.
Can be a character vector of traditional package repositories (as with install.packages)
or a PkgManifest or SessionManifest (or a url thereof)}

\item{versions}{An optional named character vector or data.frame specifying exact versions of the packages to install}

\item{verbose}{Should extra information be printed during the console during installation}

\item{\dots}{extra parameters passed directly to install.packages}
}
\description{
Install packages from a set of traditional repositories, or a Just-in-time
repository constructed using a PkgManifest or SessionManifest
}
\details{
In addition to installing the specified packages, this function
annotates the installed DESCRIPTION files with provenance information
about where the packages were installed from. This retains the information
necessary to generate a manifest of installed packages for publication or
reinstallation.

When \code{repos} is a vector of traditional repositories, this function -
with the exception of the provenance mentioned above - behaves identically
to \code{\link{install.packages}}. Otherwise, a Just-in-Time package
repository is constructed using the information in the manifest(s) passed
to \code{repos}, which is then used in conjuction with
\code{link{install.packages}} to do the actual installation.
}
\examples{
\dontrun{
## equivalent to install.packages, except it stores
## package provenance and knows about bioconductor repos
install_packages("nlme")

## install from a manifest
man = GithubManifest("gmbecker/fastdigest")
install_packages("fastdigest", man)

## install a full seeding manifest
man2 = makeSeedMan("myotherlib")
install_packages(man2)
}
}
\references{
Becker G, Barr C, Gentleman R, Lawrence M; Enhancing Reproducibility and Collaboration via Management of R Package Cohorts. Journal of Statistical Software, 81(1). 2017. doi: 10.18637/jss.v082.i01
}
\author{
Gabriel Becker
}
