% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula.R
\name{formula_split}
\alias{formula_split}
\title{Split formula by symbol}
\usage{
formula_split(formula, symbol = "|")
}
\arguments{
\item{formula}{an object of class \code{formula}.}

\item{symbol}{a string that is used to split \code{formula} into
two formulas.}
}
\value{
This function returns a list of two formulas.
}
\description{
This function splits one formula into two formulas
by symbol.
}
\details{
The \code{symbol} should be on the right hand side of
the formula.
}
\examples{
formula_split("y ~ x1 + x2 | x2 + x3")
formula_split("y ~ x1 + x2 : x2 + x3", symbol = ":")

}
