% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/rmatch_calls.R
\name{rmatch_calls}
\alias{rmatch_calls}
\title{Recursively expand match calls in an expression from the bottom up.}
\usage{
rmatch_calls(expr, eval_for_class = FALSE, eval_env = NULL)
}
\arguments{
\item{expr}{an R expression (a.k.a. abstract syntax tree)}

\item{eval_for_class}{TRUE or FALSE. If TRUE, evaluate the first argument of an S3 method to determine its class. Default=FALSE.}

\item{eval_env}{environment in which to evaluate for class. Ignored if eval_for_class=FALSE}
}
\value{
an equivalent R expression with function or method calls in canonical form.
}
\description{
Given an expression, expr, traverse the syntax tree from the
bottom up, expanding the call to include default values of
named formals as appropriate, and applying match.call to the result.
Functionality is limited to expressions containing ordinary functions
or S3 methods. If parameter eval_for_class has its default value of FALSE,
an error will be raised for any S3 method whose first argument (as an expression)
is not atomic. If eval_for_class is TRUE, the first argument will be evaluated
to determine its class. Evaluation will take place in the environment given by
parameter eval_env.
CAUTION: eval_for_class=TRUE is likely to result in multiple evaluations of the same code.
Expressions containing S4 or reference class methods will also raise errors.
}
\examples{
\dontrun{

# Function
> rmatch_calls(quote(help("print")))
help(topic = "print", package = NULL, lib.loc = NULL, verbose = getOption("verbose"),
try.all.packages = getOption("help.try.all.packages"), help_type = getOption("help_type"))

# S3 method with atomic first argument
> rmatch_calls(quote(seq(0, 1, by=.5)))
seq(from = 0, to = 1, by = 0.5, length.out = NULL, along.with = NULL)

# S3 method with non-atomic first argument, eval_for_class = FALSE (default)
> rmatch_calls(quote(seq(as.Date("2014-02-01"), as.Date("2014-03-01"))))
Error in rmatch_calls(quote(seq(as.Date("2014-02-01"), as.Date("2014-03-01")))) :
 Illegal expression, seq(as.Date(x = "2014-02-01"), as.Date(x = "2014-03-01")):
 The first argument, as.Date(x = "2014-02-01"), to S3 method 'seq', is a call,
 which (as an expression) is not atomic, hence its class can't be determined in an
 abstract syntax tree without additional information.

# S3 method with non-atomic first argument, eval_for_class = TRUE
> rmatch_calls(quote(seq(as.Date("2014-02-01"), as.Date("2014-03-01"))), eval_for_class=TRUE)
seq(from = as.Date(x = "2014-02-01"), to = as.Date(x = "2014-03-01"),
    length.out = NULL, along.with = NULL)
}
}

