% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swimplot.R
\name{swimmer_arrows}
\alias{swimmer_arrows}
\title{Adding arrows to a swimmers plot}
\usage{
swimmer_arrows(
  df_arrows,
  id = "id",
  arrow_start = "end",
  name_col = NULL,
  cont = NULL,
  arrow_positions = c(0.1, 1),
  angle = 30,
  length = ggplot2::unit(0.1, "inches"),
  type = "closed",
  ...
)
}
\arguments{
\item{df_arrows}{a data frame}

\item{id}{column name for id, default is 'id'}

\item{arrow_start}{column name with the arrow locations default is "end"}

\item{name_col}{a column name to map the arrow colour}

\item{cont}{a column name including an indicator of which ids have an arrow (NA is no arrow); when  NULL will use
all use all of df_arrows}

\item{arrow_positions}{a vector of the distance from the arrow start to end,
default is c(0.1,1)}

\item{angle}{the angle of the arrow head in degrees (smaller numbers produce
narrower, pointier arrows). Essentially describes the width of the arrow
head. Default is 30}

\item{length}{a unit specifying the length of the arrow head (from tip to
base).Default is 'unit(0.1, "inches")'}

\item{type}{one of "open" or "closed" indicating whether the arrow head
should be a closed triangle. Default is 'closed'}

\item{...}{additional geom_segment() arguments}
}
\value{
a swimmer plot with arrows
}
\description{
This function allows you to add arrows to a swimmers plot created with
\code{\link{swimmer_plot}}
}
\examples{

#Mapping the arrows to the bars




swim_plot <-
swimmer_plot(df=ClinicalTrial.Arm,id='id',end='End_trt',name_fill='Arm',col="black",id_order
= 'Arm')



swim_plot_with_arrows <- swim_plot+
swimmer_arrows(df_arrows=ClinicalTrial.Arm,id='id',arrow_start='End_trt',
cont = 'Continued_treatment',name_col='Arm',show.legend = FALSE,type =
"open",cex=1.25)



 swim_plot_with_arrows+
ggplot2::scale_color_manual(name="Treatment",values=c("#e41a1c", "#377eb8","#4daf4a"),drop=FALSE)+
ggplot2::scale_fill_manual(name="Treatment",values=c("#e41a1c", "#377eb8","#4daf4a"))+
ggplot2::ylab('Time (Days)')






#Mapping the arrows to lines

#Start with a base swimmer plot with lines and points


swim_plot <-
swimmer_plot(df=ClinicalTrial.Arm,id='id',end='End_trt',name_fill='Arm',col="black",id_order
= 'Arm')+ swimmer_lines(df_lines=ClinicalTrial.Response,id='id',start =
'Response_start',end='Response_end',name_col='Response',size=3)+
swimmer_points_from_lines(df_lines=ClinicalTrial.Response,id='id',start =
'Response_start',end = 'Response_end',cont =
'Continued_response',name_col='Response',size=4)


# Then add arrows to the plot

  swim_plot_with_arrows <- swim_plot+
swimmer_arrows(df_arrows=ClinicalTrial.Response,id='id',arrow_start='Response_end',
cont = 'Continued_response',name_col='Response',show.legend = FALSE,type =
"open",cex=1.25)


# Add ggplot layers to improve the plot's aesthetic

swim_plot_with_arrows+
ggplot2::scale_color_manual(name="Response",values=c("grey20","grey80"))+
ggplot2::scale_fill_manual(name="Treatment",values=c("#e41a1c", "#377eb8","#4daf4a"))+
ggplot2::ylab('Time (Days)')+
ggplot2::guides(fill = ggplot2::guide_legend(override.aes = list(shape =
NA)))+
ggplot2::scale_shape_manual(name='',values=c(17,15),breaks =
c('Response_start','Response_end'),labels=c('Response Start','Response End'))


}
\seealso{
\code{\link{swimmer_plot}} \code{\link{swimmer_points}} \code{\link{swimmer_lines}}  \code{\link{swimmer_lines}}  \code{\link{swimmer_points_from_lines}}
}
