% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svgtools.R
\name{scatterSymbols}
\alias{scatterSymbols}
\title{Adjust symbols of a scatter plot}
\usage{
scatterSymbols(
  svg,
  frame_name,
  group_name,
  scale_real_x,
  scale_real_y,
  values,
  symbol_type
)
}
\arguments{
\item{svg}{XML document with SVG content}

\item{frame_name}{Name (attribute 'id') of frame (XML element 'rect') for positioning of elements.}

\item{group_name}{Name (attribute 'id') of group (XML element 'g') with symbols.}

\item{scale_real_x}{Numeric vector (e.g. \code{c(0,100)}) of arbitrary length for x-axis. Only minimum and maximum are used for scaling of values.}

\item{scale_real_y}{Numeric vector (e.g. \code{c(0,100)}) of arbitrary length for y-axis. Only minimum and maximum are used for scaling of values.}

\item{values}{Dataframe or matrix with numeric vectors. First column corresponds to x-axis. Second column corresponds to y-axis.}

\item{symbol_type}{Character value. Accepts 'circle', 'rect', 'polygon' or 'linegroup'; see details.}
}
\value{
XML document with SVG content
}
\description{
Adjusts the horizontal (XML attributes 'x', 'x1', 'x2', 'cx' etc.) and vertical (XML attributes 'y', 'y1', 'y2', 'cy' etc.) positions of symbols (see details). Positions are calculated relative to a given frame (XML element of type 'rect') and the position of a data value within the minimum and maximum of two given scales for x- and y-axis. This process is called scaling.\cr
In preparation, it is necessary to name a group (set attribute 'id' of XML element of type 'g') of symbols. Symbols are automatically duplicated or removed to match the amount of data values.
}
\details{
Symbols may be prepared in the SVG file in any amount. But be aware that the function will simply duplicate the first one (in the group) or remove the last ones to match the amount of data values. When, for example, you need to have different colors for different subgroups of cases, prepare several groups of symbols and call this function for each of them.\cr
The function currently supports the following \code{symbol_type}s:
\itemize{
\item circle: XML elements of type 'circle'. Attributes 'cx' and 'cy' are adjusted.
\item rect: XML elements of type 'rect'. Attributes 'x' and 'y' are adjusted.
\item polygon: XML elements of type 'polygon'. Attribute 'points' is adjusted so that the centroid of the shape matches the scaled value positions on the chart.
\item linegroup: XML elements of type 'g' that contain elements of type 'line'. Attributes 'x1', 'x2', 'y1' and 'y2' of those lines are adjusted so that the mean x- and y-coordinate of all lines in the group matches the scaled value positions on the chart.
}
}
\examples{
#read SVG file
fpath <- system.file("extdata", "fig13.svg", package="svgtools")
svg <- read_svg(file = fpath)

#scatter symbols
set.seed(12345)
df <- data.frame(g=rep(1:4,10), x=rnorm(40,500,75), y=rnorm(40,500,75))
df[df$g==1,]$x <- df[df$g==1,]$x-35
df[df$g==2,]$y <- df[df$g==2,]$y-35
df[df$g==3,]$x <- df[df$g==3,]$x+35
df[df$g==4,]$y <- df[df$g==4,]$y+35
svg <- scatterSymbols(svg = svg, frame_name = "frame", group_name = "gA", 
                      scale_real_x = c(250,750), scale_real_y = c(250,750), 
                      values = df[df$g==1,2:3], symbol_type = "rect")
svg <- scatterSymbols(svg = svg, frame_name = "frame", group_name = "gB", 
                      scale_real_x = c(250,750), scale_real_y = c(250,750), 
                      values = df[df$g==2,2:3], symbol_type = "circle")
svg <- scatterSymbols(svg = svg, frame_name = "frame", group_name = "gC", 
                      scale_real_x = c(250,750), scale_real_y = c(250,750), 
                      values = df[df$g==3,2:3], symbol_type = "polygon")
svg <- scatterSymbols(svg = svg, frame_name = "frame", group_name = "gD", 
                      scale_real_x = c(250,750), scale_real_y = c(250,750), 
                      values = df[df$g==4,2:3], symbol_type = "linegroup")
}
