% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SVG.R
\name{svgstring}
\alias{svgstring}
\title{Access current SVG as a string.}
\usage{
svgstring(
  width = 10,
  height = 8,
  bg = "white",
  pointsize = 12,
  standalone = TRUE,
  system_fonts = list(),
  user_fonts = list(),
  web_fonts = list(),
  id = NULL,
  fix_text_size = TRUE,
  scaling = 1
)
}
\arguments{
\item{width}{Height and width in inches.}

\item{height}{Height and width in inches.}

\item{bg}{Default background color for the plot (defaults to "white").}

\item{pointsize}{Default point size.}

\item{standalone}{Produce a standalone svg file? If \code{FALSE}, omits
xml header and default namespace.}

\item{system_fonts}{\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#superseded'><img src='figures/lifecycle-superseded.svg' alt='Superseded lifecycle'></a>}}{\strong{Superseded}} \emph{Consider using
\code{\link[systemfonts:register_font]{systemfonts::register_font()}} instead}. Named list of font
names to be aliased with fonts installed on your system. If unspecified,
the R default families \code{sans}, \code{serif}, \code{mono} and
\code{symbol} are aliased to the family returned by
\code{\link[systemfonts]{font_info}()}.}

\item{user_fonts}{\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#superseded'><img src='figures/lifecycle-superseded.svg' alt='Superseded lifecycle'></a>}}{\strong{Superseded}} \emph{Consider using
\code{\link[systemfonts:register_font]{systemfonts::register_font()}} instead}. Named list of fonts to
be aliased with font files provided by the user rather than fonts properly
installed on the system. The aliases can be fonts from the fontquiver
package, strings containing a path to a font file, or a list containing
\code{name} and \code{file} elements with \code{name} indicating
the font alias in the SVG output and \code{file} the path to a
font file.}

\item{web_fonts}{A list containing web fonts to use in the SVG. The fonts
will still need to be available locally on the computer running the code,
but viewers of the final SVG will not need the font if specified as a web
font. Web fonts can either be specified using \code{\link[=font_face]{font_face()}} or given as a
single string in which case they are taken to be URL's for an \verb{@import}
directive to e.g. Google Fonts.}

\item{id}{A character vector of ids to assign to the generated SVG's. If
creating more SVG files than supplied ids the exceeding SVG's will not have
an id tag and a warning will be thrown.}

\item{fix_text_size}{Should the width of strings be fixed so that it doesn't
change between svg renderers depending on their font rendering? Defaults to
\code{TRUE}. If \code{TRUE} each string will have the \code{textLength} CSS property set
to the width calculated by systemfonts and
\code{lengthAdjust='spacingAndGlyphs'}. Setting this to \code{FALSE} can be
beneficial for heavy post-processing that may change content or style of
strings, but may lead to inconsistencies between strings and graphic
elements that depend on the dimensions of the string (e.g. label borders
and background).}

\item{scaling}{A scaling factor to apply to the rendered line width and text
size. Useful for getting the right sizing at the dimension that you
need.}
}
\value{
A function with no arguments: call the function to get the
current value of the string.
}
\description{
This is a variation on \code{\link{svglite}} that makes it easy to access
the current value as a string.
}
\details{
See \code{\link{svglite}()} documentation for information about
specifying fonts.
}
\examples{
s <- svgstring(); s()

plot.new(); s();
text(0.5, 0.5, "Hi!"); s()
dev.off()

s <- svgstring()
plot(rnorm(5), rnorm(5))
s()
dev.off()
}
